<div>
    <div class="py-5">
        <div class="container">

            <div class="row">
                <div class="col-12 col-lg-3 d-none d-lg-block">
                   <?php echo $__env->make('user.user-menu', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>

                <div class="col-12 col-lg-9">
                    <div class="d-block overflow-hidden">
                        <h2 class="text-xl font-bold mb-4">🛍️ Pesanan Saya</h2>
                        <hr class="soft">
                        <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="d-block border rounded mb-4 shadow-sm">
                                <div class="d-flex justify-content-between align-items-center mb-2 px-3 py-2 border-bottom">
                                    <small>
                                        <div class="text-sm text-secondary">No. Invoice</div>
                                        <div class="font-semibold text-blue-600"><?php echo e($order->invoice); ?></div>
                                    </small>
                                    <div>
                                         <!--[if BLOCK]><![endif]--><?php if($order->status == 'pending'): ?>
                                            <span class="badge text-bg-warning">Pending</span>
                                        <?php elseif($order->status == 'waiting'): ?>
                                            <span class="badge text-bg-info">Menunggu Pembayaran</span>
                                        <?php elseif($order->status == 'process'): ?>
                                            <span class="badge text-bg-primary">Sedang diproses</span>
                                        <?php elseif($order->status == 'completed'): ?>
                                            <span class="badge text-bg-success">Selesai</span>
                                        <?php elseif($order->status == 'reviewd'): ?>
                                            <span class="badge text-bg-secondary">reviewd</span>
                                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                    </div>
                                </div>
                
                                <div class="position-relative">
                                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="d-flex align-items-center gap-3 mb-1 py-2 px-3">
                                            <img src="/images/product/<?php echo e($item->images); ?>" alt="<?php echo e($item->images); ?>" class="img-fluid" width="92px" height="92px">
                                            <div class="lh-1">
                                                <div><?php echo e($item->title); ?></div>
                                                <small class="text-secondary">(x<?php echo e($item->qty); ?>)</small>
                                                <div class="text-xs text-gray-500"><?php echo e($item->note); ?></div>
                                            </div>
                                            <div class="text-end ms-auto">
                                                Rp <?php echo e(number_format($item->total, 0, ',', '.')); ?>

                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                                    <a href="<?php echo e(route('user.orders.detail', ['inv' => $order->invoice])); ?>" class="stretched-link"></a>
                                </div>
                
                                <div class="d-flex align-items-center justify-content-between border-top text-end p-3">
                                    <small><i class="fad fa-calendar fa-sm me-2" aria-hidden="true"></i><?php echo e(date('d F Y', strtotime($order->order_date))); ?></small>
                                    <div>
                                        <span class="me-2">Total Pesanan:</span> 
                                        <span class="text-danger fs-5">
                                            Rp<?php echo e(number_format($order->items->sum('total'), 0, ',', '.')); ?>

                                        </span>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <div class="text-gray-500">Belum ada pesanan 🤗</div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>
<?php /**PATH D:\Project\laravel\laundrymu\resources\views/user/user-orders.blade.php ENDPATH**/ ?>