<div>
    <div class="container-fluid">

        <div class="d-block p-3 mb-2">
            <h2 class="text-them fw-bold mb-0">Detail Order Laundry</h2>
            <p class="text-them-sec mb-0">Selamat datang kembali di aplikasi laundryku</p>
        </div>

        <div class="d-block bg-white rounded p-3 mb-3">
            <div class="d-flex justify-content-between align-items-center mb-2 px-3 py-2 border-bottom">
                <small>
                    <div class="text-sm text-secondary">No. Invoice</div>
                    <div class="font-semibold text-blue-600"><?php echo e($order->invoice); ?></div>
                </small>
                <div>
                    <span
                        class="badge p-2 
                                <?php echo e($order->status == 'pending'
                                    ? 'text-bg-warning'
                                    : ($order->status == 'waiting'
                                        ? 'text-bg-info'
                                        : ($order->status == 'process'
                                            ? 'text-bg-primary'
                                            : ($order->status == 'pickup'
                                                ? 'text-bg-info'
                                                : ($order->status == 'completed'
                                                    ? 'text-bg-success'
                                                    : 'text-bg-secondary'))))); ?>">
                        <?php echo e(ucfirst($order->status)); ?>

                    </span>
                </div>
            </div>
            <div class="p-5 mb-5">
                <div class="position-relative m-4">
                    <div class="progress" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100" style="height: 4px;">
                        <div
                            class="progress-bar bg-success <?php if($order->status == 'pending'): ?> w-0 <?php elseif($order->status == 'waiting'): ?> w-25 <?php elseif($order->status == 'process'): ?> w-50 <?php elseif($order->status == 'pickup'): ?> w-75 <?php elseif($order->status == 'completed'): ?> w-100 <?php else: ?> w-0 <?php endif; ?>">
                        </div>
                    </div>
                    <div class="bg-white <?php if(in_array($order->status, ['waiting', 'pending', 'process', 'completed', 'pickup'])): ?> border-success text-success <?php else: ?> border-secondary text-secondary <?php endif; ?> position-absolute top-0 translate-middle rounded-pill d-flex align-items-center justify-content-center"
                        style="border: 3px solid; width: 4rem; height:4rem; left:   0%;">
                        <i class="fad fa-receipt fa-lg fa-fw"></i>
                    </div>
                    <small class="position-absolute translate-middle fw-bold text-secondary"
                        style="top: 50px; left: 0%">
                        Pesanan dibuat
                    </small>
                    <div class="bg-white <?php if(in_array($order->status, ['waiting', 'process', 'completed', 'pickup'])): ?> border-success text-success <?php else: ?> border-secondary text-secondary <?php endif; ?> position-absolute top-0 translate-middle rounded-pill d-flex align-items-center justify-content-center"
                        style="border: 3px solid; width: 4rem; height:4rem; left:  25%;">
                        <i class="fad fa-sack-dollar fa-lg fa-fw"></i>
                    </div>
                    <small class="position-absolute translate-middle fw-bold text-secondary"
                        style="top: 50px; left: 25%">
                        Menunggu pembayaran
                    </small>
                    <div class="bg-white <?php if(in_array($order->status, ['process', 'completed', 'pickup'])): ?> border-success text-success <?php else: ?> border-secondary text-secondary <?php endif; ?> position-absolute top-0 translate-middle rounded-pill d-flex align-items-center justify-content-center"
                        style="border: 3px solid; width: 4rem; height:4rem; left:  50%;">
                        <i class="fad fa-sync-alt fa-lg fa-fw"></i>
                    </div>
                    <small class="position-absolute translate-middle fw-bold text-secondary"
                        style="top: 50px; left: 50%">
                        Sedang diproses
                    </small>
                    <div class="bg-white <?php if(in_array($order->status, ['completed', 'pickup'])): ?> border-success text-success <?php else: ?> border-secondary text-secondary <?php endif; ?> position-absolute top-0 translate-middle rounded-pill d-flex align-items-center justify-content-center"
                        style="border: 3px solid; width: 4rem; height:4rem; left:  75%;">
                        <i class="fad fa-people-carry fa-lg fa-fw"></i>
                    </div>
                    <small class="position-absolute translate-middle fw-bold text-secondary"
                        style="top: 50px; left: 75%">
                        Pesanan siap diambil
                    </small>
                    <div class="bg-white <?php if($order->status == 'completed'): ?> border-success text-success <?php else: ?> border-secondary text-secondary <?php endif; ?> position-absolute top-0 translate-middle rounded-pill d-flex align-items-center justify-content-center"
                        style="border: 3px solid; width: 4rem; height:4rem; left: 100%;">
                        <i class="fad fa-box-check fa-lg fa-fw"></i>
                    </div>
                    <small class="position-absolute translate-middle fw-bold text-secondary"
                        style="top: 50px; left: 100%">
                        Selesai
                    </small>
                </div>
            </div>
            <div class="d-block p-3 mb-3 border-secondary" style="border-top: 2px dashed; border-bottom: 2px dashed;">
                <div class="d-flex justify-content-between align-items-center">
                    <p class="fs-5">Alamat Pengiriman</p>
                    <small class="lh-0 text-secondary text-end">
                        <div><?php echo e($shipment->courier); ?></div>
                        <div><?php echo e($shipment->tracking_number); ?></div>
                        <div><?php echo e($shipment->status); ?></div>
                    </small>
                </div>
                <small>
                    <div class="fw-bold"><?php echo e($shipment->recipient_name); ?></div>
                    <div class="text-secondary mb-3"><?php echo e($shipment->recipient_phone); ?></div>
                    <div>
                        <div class="text-secondary text-uppercase m-0">
                            <?php echo e($shipment->address_line); ?>

                        </div>
                        <div class="text-secondary m-0">
                            <span><?php echo e($shipment->village); ?> </span>
                            <span><?php echo e($shipment->districts); ?>, </span>
                            <span><?php echo e($shipment->regencies); ?>, </span>
                            <span><?php echo e($shipment->province); ?>, </span>
                            <span><?php echo e($shipment->postal_code); ?> </span>
                        </div>
                    </div>
                </small>
            </div>
            <div class="p-3">
                <p class="fs-5">Detail Pesanan</p>
                <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="d-flex align-items-center gap-3 mb-2">
                        <img src="/images/product/<?php echo e($item->images); ?>" alt="<?php echo e($item->images); ?>" class="img-fluid"
                            width="92px" height="92px">
                        <div class="lh-1">
                            <div><?php echo e($item->title); ?></div>
                            <small class="text-secondary">(x<?php echo e($item->qty); ?>)</small>
                            <div class="text-xs text-gray-500"><?php echo e($item->note); ?></div>
                        </div>
                        <div class="text-end ms-auto">
                            Rp <?php echo e(number_format($item->price, 0, ',', '.')); ?>

                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
            </div>
            <table class="table table-bordered rounded-0 m-0 mb-4">
                <tbody>
                    <tr class="fw-light text-end ">
                        <td style="font-size: 0.8rem">Subtotal Pesanan</td>
                        <td style="width: 13rem">Rp<?php echo e(number_format($order->items->sum('total'), 0, ',', '.')); ?></td>
                    </tr>
                    <tr class="fw-light text-end ">
                        <td style="font-size: 0.8rem">Subtotal Pengiriman</td>
                        <td style="width: 13rem">Rp<?php echo e(number_format(0, 0, ',', '.')); ?></td>
                    </tr>
                    <tr class="fw-light text-end ">
                        <td style="font-size: 0.8rem">Biaya Layanan</td>
                        <td style="width: 13rem">Rp<?php echo e(number_format(0, 0, ',', '.')); ?></td>
                    </tr>
                    <tr class="fw-light text-end ">
                        <td style="font-size: 0.8rem">Total Harga</td>
                        <td style="width: 13rem" class="text-danger fs-4">
                            Rp<?php echo e(number_format($order->items->sum('total'), 0, ',', '.')); ?></td>
                    </tr>
                    <tr class="fw-light text-end">
                        <td style="font-size: 0.8rem">Metode Pembayaran</td>
                        <td style="width: 13rem"><?php echo e($order->payment_method); ?></td>
                    </tr>
                </tbody>
            </table>
        </div>

        <!--[if BLOCK]><![endif]--><?php if(count($payment) != 0): ?>
            <div class="d-block bg-white rounded p-3 mb-3">
                <p class="fs-5">Pembayaran</p>
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Invoice</th>
                            <th>Date</th>
                            <th>Harga</th>
                            <th>Bayar</th>
                            <th>Sisa Pembayaran</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $bayars = 0; ?>
                        <?php $harga = $order->amount; ?>
                        <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $payment; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($index + 1); ?></td>
                                <td><?php echo e($item->invoice); ?></td>
                                <td><?php echo e($item->date); ?></td>
                                <td>Rp <?php echo e(number_format($harga, 0, ',', '.')); ?></td>
                                <td>Rp <?php echo e(number_format($item->amount, 0, ',', '.')); ?></td>
                                <?php $bayars += $item->amount; ?>
                                <?php $harga = $order->amount - $bayars; ?>
                                <td>Rp <?php echo e(number_format($harga, 0, ',', '.')); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    </tbody>
                    
                </table>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->


        <div class="d-block bg-white rounded p-3 mb-3">
            <div class="d-flex gap-3 justify-content-end">
                <!--[if BLOCK]><![endif]--><?php if($order->status == 'pending'): ?>
                    <button type="button" class="btn btn-warning px-3" data-bs-toggle="modal"
                        data-bs-target="#ModalUpdated">Update</button>
                <?php elseif($order->status == 'waiting'): ?>
                    <button type="button" class="btn btn-info px-3" data-bs-toggle="modal"
                        data-bs-target="#ModalPayment">Payment</button>
                <?php elseif($order->status == 'process'): ?>
                    <button type="button" class="btn btn-success px-3" wire:click='complete'>Completed</button>
                <?php elseif($order->status == 'pickup'): ?>
                    <!--[if BLOCK]><![endif]--><?php if(count($payment) != 0): ?>
                        <!--[if BLOCK]><![endif]--><?php if($payment->sum('amount') != $order->amount): ?>
                            <button type="button" class="btn btn-info px-3" data-bs-toggle="modal"
                                data-bs-target="#ModalPayment">Pelunasan</button>
                        <?php else: ?>
                            <button type="button" class="btn btn-success px-3"
                                wire:click='completed'>Completed</button>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                <!--[if BLOCK]><![endif]--><?php if($order->status != 'completed'): ?>
                    <button type="button" class="btn btn-secondary px-3">cancle</button>
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
            </div>
        </div>

    </div>



    <div class="modal fade" id="ModalUpdated" tabindex="-1" wire:ignore.self>
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="exampleModalLabel">Change Weight Order Laundry</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="weight" class="form-label">Invoice</label>
                        <input type="text" class="form-control" value="<?php echo e($order->invoice); ?>" disabled>
                    </div>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="mb-3">
                            <label for="weight" class="form-label">Product</label>
                            <div class="form-control disable">
                                <div><?php echo e($item->title); ?></div>
                                <div><?php echo e(number_format($item->price, 0, ',', '.')); ?></div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    <div class="input-group mb-3">
                        <input type="number" class="form-control" wire:model.live='weight' id="weight">
                        <label class="input-group-text" for="weight">.Kg</label>
                    </div>
                    <div class="mb-3">
                        <table class="table table-bordered">
                            <tbody>
                                <tr>
                                    <td>Harga Product</td>
                                    <td><?php echo e(number_format($item->price, 0, ',', '.')); ?></td>
                                </tr>
                                <tr>
                                    <td>Berat Product</td>
                                    <td><?php echo e($weight); ?></td>
                                </tr>
                                <tr>
                                    <td>Total Harga Product</td>
                                    <td><?php echo e(number_format($item->price * $weight, 0, ',', '.')); ?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                    <?php
                        $this->amount = $item->price * $weight;
                    ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" wire:click='save'>Save changes</button>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="ModalPayment" tabindex="-1" wire:ignore.self>
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h1 class="modal-title fs-5" id="exampleModalLabel">Create Pembayaran</h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="weight" class="form-label">Invoice</label>
                        <input type="text" class="form-control" value="<?php echo e($order->invoice); ?>" disabled>
                    </div>
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="mb-3">
                            <label for="weight" class="form-label">Product</label>
                            <div class="form-control disable">
                                <div><?php echo e($item->title); ?></div>
                                <div><?php echo e(number_format($item->price, 0, ',', '.')); ?> <small>x
                                        <?php echo e($item->qty); ?></small> </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                    <div class="mb-3">
                        <table class="table table-bordered">
                            <tbody>
                                <tr>
                                    <td>Total Harga Product</td>
                                    <td class="text-end">Rp <?php echo e(number_format($order->amount, 0, ',', '.')); ?></td>
                                </tr>
                                <!--[if BLOCK]><![endif]--><?php if(count($payment) != 0): ?>
                                    <tr>
                                        <td>Sudah dibayarkan</td>
                                        <td class="text-end">Rp
                                            <?php echo e(number_format($payment->sum('amount'), 0, ',', '.')); ?></td>
                                    </tr>
                                    <tr>
                                        <td>Sisa yang harus dibayarkan</td>
                                        <td class="text-end">Rp
                                            <?php echo e(number_format($order->amount - $payment->sum('amount'), 0, ',', '.')); ?>

                                        </td>
                                    </tr>
                                    <?php $this->buyer = $order->amount - $payment->sum('amount'); ?>
                                <?php else: ?>
                                    <!--[if BLOCK]><![endif]--><?php if($item->total >= $item->total - $buyer): ?>
                                        <tr>
                                            <td>Sisa Pembayaran</td>
                                            <td class="text-end">Rp
                                                <?php echo e(number_format($item->total - $buyer, 0, ',', '.')); ?></td>
                                        </tr>
                                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            </tbody>
                        </table>
                    </div>
                    <!--[if BLOCK]><![endif]--><?php if($order->status == 'waiting'): ?>
                        <div class="mb-3">
                            <label for="pay" class="form-label">Total Akan dibayar</label>
                            <input type="number" class="form-control" wire:model.live='buyer'>
                        </div>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" wire:click='payment'>Save changes</button>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH D:\Project\laravel\laundrymu\resources\views/admin/order/admin-order-detail.blade.php ENDPATH**/ ?>