<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($title ?? 'Admin Panel - Sistem Kasir'); ?></title>
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>

<body class="min-h-screen bg-gradient-to-br from-yellow-200 via-orange-200 to-red-200">
    <div class="flex">
        <!-- Sidebar -->
        <div class="fixed left-0 top-0 w-64 h-screen bg-yellow-50 backdrop-blur-sm border-r border-orange-200 shadow-2xl z-30">
            <!-- Header -->
            <div class="p-6 border-b border-orange-200">
                <div class="flex items-center space-x-3">
                    <div class="w-10 h-10 bg-gradient-to-r from-orange-500 to-red-600 rounded-xl flex items-center justify-center shadow-lg shadow-orange-500/25">
                        <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                        </svg>
                    </div>
                    <div>
                        <h2 class="text-xl font-bold text-gray-800">Admin Panel</h2>
                        <p class="text-sm text-gray-600">Sistem Kasir</p>
                    </div>
                </div>
            </div>

            <!-- Navigation -->
            <nav class="flex-1 px-4 py-6 space-y-2 overflow-y-auto">
                <!-- Dashboard -->
                <a href="<?php echo e(route('admin.dashboard')); ?>"
                    class="group flex items-center px-4 py-3 text-gray-700 rounded-xl hover:bg-orange-100 transition-all duration-300 <?php echo e(request()->routeIs('admin.dashboard') ? 'bg-gradient-to-r from-orange-200 to-red-200 text-red-700 border border-orange-300 shadow-md' : 'hover:text-red-700'); ?>">
                    <div class="p-2 rounded-lg <?php echo e(request()->routeIs('admin.dashboard') ? 'bg-gradient-to-r from-orange-300 to-red-300' : 'bg-yellow-100 group-hover:bg-orange-100'); ?> transition-all duration-300">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M3 7v10a2 2 0 002 2h14a2 2 0 002-2V9a2 2 0 00-2-2H5a2 2 0 00-2-2z"></path>
                        </svg>
                    </div>
                    <span class="ml-3 font-medium">Dashboard</span>
                    <?php if(request()->routeIs('admin.dashboard')): ?>
                        <div class="ml-auto w-2 h-2 bg-red-500 rounded-full shadow-sm"></div>
                    <?php endif; ?>
                </a>

                <!-- Categories -->
                <a href="<?php echo e(route('admin.categories.index')); ?>"
                    class="group flex items-center px-4 py-3 text-gray-700 rounded-xl hover:bg-yellow-100 transition-all duration-300 <?php echo e(request()->routeIs('admin.categories.*') ? 'bg-gradient-to-r from-yellow-200 to-orange-200 text-orange-700 border border-yellow-300 shadow-md' : 'hover:text-orange-700'); ?>">
                    <div class="p-2 rounded-lg <?php echo e(request()->routeIs('admin.categories.*') ? 'bg-gradient-to-r from-yellow-300 to-orange-300' : 'bg-yellow-100 group-hover:bg-yellow-100'); ?> transition-all duration-300">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z">
                            </path>
                        </svg>
                    </div>
                    <span class="ml-3 font-medium">Kategori</span>
                    <?php if(request()->routeIs('admin.categories.*')): ?>
                        <div class="ml-auto w-2 h-2 bg-orange-500 rounded-full shadow-sm"></div>
                    <?php endif; ?>
                </a>

                <!-- Products -->
                <a href="<?php echo e(route('admin.product.index')); ?>"
                    class="group flex items-center px-4 py-3 text-gray-700 rounded-xl hover:bg-pink-100 transition-all duration-300 <?php echo e(request()->routeIs('admin.products.*') ? 'bg-gradient-to-r from-pink-200 to-purple-200 text-purple-700 border border-pink-300 shadow-md' : 'hover:text-purple-700'); ?>">
                    <div class="p-2 rounded-lg <?php echo e(request()->routeIs('admin.products.*') ? 'bg-gradient-to-r from-pink-300 to-purple-300' : 'bg-yellow-100 group-hover:bg-pink-100'); ?> transition-all duration-300">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                        </svg>
                    </div>
                    <span class="ml-3 font-medium">Produk</span>
                    <?php if(request()->routeIs('admin.products.*')): ?>
                        <div class="ml-auto w-2 h-2 bg-purple-500 rounded-full shadow-sm"></div>
                    <?php endif; ?>
                </a>

                <!-- Transactions -->
                <a href="<?php echo e(route('admin.transactions.index')); ?>"
                    class="group flex items-center px-4 py-3 text-gray-700 rounded-xl hover:bg-red-100 transition-all duration-300 <?php echo e(request()->routeIs('admin.transactions.*') ? 'bg-gradient-to-r from-red-100 to-pink-100 text-red-800 border border-red-300 shadow-md' : 'hover:text-red-800'); ?>">
                    <div class="p-2 rounded-lg <?php echo e(request()->routeIs('admin.transactions.*') ? 'bg-gradient-to-r from-red-200 to-pink-200' : 'bg-yellow-100 group-hover:bg-red-100'); ?> transition-all duration-300">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                            </path>
                        </svg>
                    </div>
                    <span class="ml-3 font-medium">Transaksi</span>
                    <?php if(request()->routeIs('admin.transactions.*')): ?>
                        <div class="ml-auto w-2 h-2 bg-red-600 rounded-full shadow-sm"></div>
                    <?php endif; ?>
                </a>

                <!-- Divider -->
                <div class="px-4 py-3">
                    <div class="border-t border-orange-200"></div>
                </div>

                <!-- Go to Cashier -->
                <a href="<?php echo e(route('kasir.dashboard')); ?>"
                    class="group flex items-center px-4 py-3 text-gray-700 rounded-xl hover:bg-gradient-to-r hover:from-pink-100 hover:to-red-100 hover:text-pink-700 transition-all duration-300 hover:border hover:border-pink-200 hover:shadow-md">
                    <div class="p-2 rounded-lg bg-yellow-100 group-hover:bg-gradient-to-r group-hover:from-pink-200 group-hover:to-red-200 transition-all duration-300">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M3 3h2l.4 2M7 13h10l4-8H5.4m0 0L7 13m0 0l-1.5 6M7 13l-1.5-6M20 13v6a2 2 0 01-2 2H6a2 2 0 01-2-2v-6">
                            </path>
                        </svg>
                    </div>
                    <span class="ml-3 font-medium">Ke Kasir</span>
                    <svg class="w-4 h-4 ml-auto opacity-0 group-hover:opacity-100 transition-opacity duration-300 text-pink-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 8l4 4m0 0l-4 4m4-4H3"></path>
                    </svg>
                </a>
            </nav>

            <!-- User Info -->
            <div class="p-4 border-t border-orange-200 bg-yellow-50/50">
                <div class="flex items-center space-x-3 mb-4">
                    <div class="w-10 h-10 bg-gradient-to-r from-orange-500 to-red-600 rounded-xl flex items-center justify-center shadow-lg">
                        <span class="text-white text-sm font-semibold"><?php echo e(substr(Auth::user()->name, 0, 1)); ?></span>
                    </div>
                    <div class="flex-1 min-w-0">
                        <p class="text-sm font-medium text-gray-800 truncate"><?php echo e(Auth::user()->name); ?></p>
                        <p class="text-xs text-gray-600">Administrator</p>
                    </div>
                </div>
                <form action="<?php echo e(route('logout')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <button type="submit"
                        class="w-full bg-gradient-to-r from-red-500 to-pink-600 hover:from-red-600 hover:to-pink-700 text-white py-3 px-4 rounded-xl text-sm font-medium transition-all duration-300 shadow-lg hover:shadow-red-300 flex items-center justify-center space-x-2 group">
                        <svg class="w-4 h-4 group-hover:scale-110 transition-transform duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                        </svg>
                        <span>Logout</span>
                    </button>
                </form>
            </div>
        </div>

        <!-- Main Content -->
        <div class="flex-1 ml-64">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
    </div>

    <!-- Alert Messages -->
    <?php if(session('success')): ?>
        <div id="alert-success"
            class="fixed top-4 right-4 bg-yellow-50 border-l-4 border-orange-500 text-orange-800 px-6 py-4 rounded-xl shadow-2xl z-50 max-w-md">
            <div class="flex items-center">
                <div class="p-2 bg-yellow-100 rounded-lg mr-4">
                    <svg class="w-5 h-5 text-orange-600" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd"
                            d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z"
                            clip-rule="evenodd"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <div class="text-orange-800 font-medium">Success!</div>
                    <div class="text-orange-700 text-sm"><?php echo e(session('success')); ?></div>
                </div>
                <button onclick="document.getElementById('alert-success').remove()"
                    class="ml-4 text-orange-600 hover:text-orange-800 transition-colors duration-200">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                </button>
            </div>
        </div>
        <script>
            setTimeout(() => {
                const alert = document.getElementById('alert-success');
                if (alert) {
                    alert.style.opacity = '0';
                    alert.style.transform = 'translateX(100%)';
                    setTimeout(() => alert.remove(), 300);
                }
            }, 5000);
        </script>
    <?php endif; ?>

    <?php if(session('error')): ?>
        <div id="alert-error"
            class="fixed top-4 right-4 bg-red-50 border-l-4 border-red-500 text-red-800 px-6 py-4 rounded-xl shadow-2xl z-50 max-w-md">
            <div class="flex items-center">
                <div class="p-2 bg-red-100 rounded-lg mr-4">
                    <svg class="w-5 h-5 text-red-600" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd"
                            d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z"
                            clip-rule="evenodd"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <div class="text-red-800 font-medium">Error!</div>
                    <div class="text-red-700 text-sm"><?php echo e(session('error')); ?></div>
                </div>
                <button onclick="document.getElementById('alert-error').remove()"
                    class="ml-4 text-red-600 hover:text-red-800 transition-colors duration-200">
                    <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd"
                            d="M4.293 4.293a1 1 0 011.414 0L10 8.586l4.293-4.293a1 1 0 111.414 1.414L11.414 10l4.293 4.293a1 1 0 01-1.414 1.414L10 11.414l-4.293 4.293a1 1 0 01-1.414-1.414L8.586 10 4.293 5.707a1 1 0 010-1.414z"
                            clip-rule="evenodd"></path>
                    </svg>
                </button>
            </div>
        </div>
        <script>
            setTimeout(() => {
                const alert = document.getElementById('alert-error');
                if (alert) {
                    alert.style.opacity = '0';
                    alert.style.transform = 'translateX(100%)';
                    setTimeout(() => alert.remove(), 300);
                }
            }, 5000);
        </script>
    <?php endif; ?>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>

</html><?php /**PATH C:\laragon\www\kasir\resources\views/admin/layouts/app.blade.php ENDPATH**/ ?>