

<?php $__env->startSection('content'); ?>
    <div class="min-h-screen bg-gradient-to-br from-gray-900 via-gray-800 to-gray-900">
        <!-- Header -->
        <div class="bg-gray-800/90 backdrop-blur-sm border-b border-gray-700 shadow-xl">
            <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between items-center h-16">
                    <div class="flex items-center space-x-4">
                        <div class="flex items-center space-x-3">
                            <div class="w-10 h-10 bg-gradient-to-r from-green-500 to-green-600 rounded-xl flex items-center justify-center">
                                <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                            </div>
                            <div>
                                <h1 class="text-xl font-bold text-white">Order Detail</h1>
                                <p class="text-xs text-gray-300">Transaction ID: <?php echo e($transaction->id); ?></p>
                            </div>
                        </div>
                        <div class="px-3 py-1.5 bg-gradient-to-r from-green-600 to-green-700 text-white text-sm rounded-full font-medium">
                            <svg class="w-4 h-4 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                            Payment Completed
                        </div>
                    </div>
                    <div class="flex items-center space-x-3">
                        <button onclick="printReceipt()" class="bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white px-4 py-2 rounded-lg text-sm font-medium transition-all duration-300 shadow-lg hover:shadow-blue-500/25">
                            <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
                            </svg>
                            Print Receipt
                        </button>
                        <a href="<?php echo e(route('kasir.dashboard')); ?>" class="bg-gradient-to-r from-amber-600 to-orange-700 hover:from-amber-700 hover:to-orange-800 text-white px-4 py-2 rounded-lg text-sm font-medium transition-all duration-300 shadow-lg hover:shadow-amber-500/25">
                            <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                            </svg>
                            Back to Kasir
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
            <!-- Success Message -->
            <?php if(session('success')): ?>
                <div class="mb-6 bg-gradient-to-r from-green-500 to-green-600 text-white px-6 py-4 rounded-xl shadow-lg border border-green-400">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <?php echo e(session('success')); ?>

                    </div>
                </div>
            <?php endif; ?>

            <!-- Order Receipt -->
            <div id="receipt" class="bg-gray-800/50 backdrop-blur-sm rounded-2xl shadow-2xl border border-gray-700">
                <!-- Receipt Header -->
                <div class="p-6 border-b border-gray-700">
                    <div class="text-center">
                        <h2 class="text-2xl font-bold text-white mb-2">Koproll Coffee</h2>
                        <p class="text-gray-400 text-sm">Semangat Bekerja kasir</p>
                        <p class="text-gray-400 text-sm"><?php echo e(now()->format('d M Y, H:i:s')); ?></p>
                    </div>
                </div>

                <!-- Transaction Info -->
                <div class="p-6 border-b border-gray-700">
                    <div class="grid grid-cols-2 gap-6">
                        <div>
                            <h3 class="font-semibold text-white mb-3">Transaction Details</h3>
                            <div class="space-y-2 text-sm">
                                <div class="flex justify-between">
                                    <span class="text-gray-400">Transaction ID:</span>
                                    <span class="text-white font-mono"><?php echo e(str_pad($transaction->id, 6, '0', STR_PAD_LEFT)); ?></span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-400">Date & Time:</span>
                                    <span class="text-white"><?php echo e($transaction->transaction_date->format('d/m/Y H:i')); ?></span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-400">Cashier:</span>
                                    <span class="text-white"><?php echo e($transaction->user->name); ?></span>
                                </div>
                            </div>
                        </div>
                        <div>
                            <h3 class="font-semibold text-white mb-3">Payment Summary</h3>
                            <div class="space-y-2 text-sm">
                                <div class="flex justify-between">
                                    <span class="text-gray-400">Total Amount:</span>
                                    <span class="text-white font-semibold">Rp <?php echo e(number_format($transaction->total_amount, 0, ',', '.')); ?></span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-400">Payment:</span>
                                    <span class="text-white">Rp <?php echo e(number_format($transaction->payment_amount, 0, ',', '.')); ?></span>
                                </div>
                                <div class="flex justify-between">
                                    <span class="text-gray-400">Change:</span>
                                    <span class="text-green-400 font-semibold">Rp <?php echo e(number_format($transaction->change_amount, 0, ',', '.')); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Order Items -->
                <div class="p-6">
                    <h3 class="font-semibold text-white mb-4 flex items-center">
                        <svg class="w-5 h-5 mr-2 text-amber-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                        </svg>
                        Order Items (<?php echo e($transaction->transactionItems->count()); ?> items)
                    </h3>
                    
                    <div class="space-y-3">
                        <?php $__currentLoopData = $transaction->transactionItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="bg-gray-700/30 p-4 rounded-xl border border-gray-600">
                                <div class="flex items-center justify-between">
                                    <div class="flex-1">
                                        <h4 class="font-semibold text-white"><?php echo e($item->product->name); ?></h4>
                                        <p class="text-sm text-gray-400"><?php echo e($item->product->category->name ?? 'No Category'); ?></p>
                                        <div class="flex items-center mt-2 text-sm">
                                            <span class="text-gray-400"><?php echo e($item->quantity); ?>x</span>
                                            <span class="text-amber-400 ml-2">Rp <?php echo e(number_format($item->price, 0, ',', '.')); ?></span>
                                        </div>
                                    </div>
                                    <div class="text-right">
                                        <p class="text-lg font-semibold text-white">Rp <?php echo e(number_format($item->subtotal, 0, ',', '.')); ?></p>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <!-- Total Section -->
                    <div class="border-t border-gray-700 mt-6 pt-6">
                        <div class="space-y-2">
                            <div class="flex justify-between text-gray-300">
                                <span>Subtotal:</span>
                                <span class="font-semibold">Rp <?php echo e(number_format($transaction->total_amount, 0, ',', '.')); ?></span>
                            </div>
                            <div class="flex justify-between font-bold text-xl text-white border-t border-gray-700 pt-3">
                                <span>TOTAL:</span>
                                <span class="text-amber-400">Rp <?php echo e(number_format($transaction->total_amount, 0, ',', '.')); ?></span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Footer -->
                <div class="p-6 border-t border-gray-700 text-center">
                    <div class="bg-gradient-to-r from-green-600/20 to-green-700/20 rounded-lg p-4 border border-green-600/30">
                        <p class="text-green-400 font-semibold text-lg mb-2">
                            <svg class="w-6 h-6 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            Order Ready to Prepare!
                        </p>
                        <p class="text-gray-300 text-sm">Thank you for your order. Please prepare the items listed above.</p>
                    </div>
                </div>
            </div>

            <!-- Action Buttons -->
            <div class="mt-6 flex flex-col sm:flex-row gap-4 justify-center">
                <button onclick="printReceipt()" class="flex-1 sm:flex-none bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white px-8 py-3 rounded-xl font-semibold transition-all duration-300 shadow-lg hover:shadow-blue-500/25">
                    <svg class="w-5 h-5 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
                    </svg>
                    Print Receipt
                </button>
                <a href="<?php echo e(route('kasir.dashboard')); ?>" class="flex-1 sm:flex-none bg-gradient-to-r from-amber-600 to-orange-700 hover:from-amber-700 hover:to-orange-800 text-white px-8 py-3 rounded-xl font-semibold transition-all duration-300 shadow-lg hover:shadow-amber-500/25 text-center">
                    <svg class="w-5 h-5 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                    </svg>
                    New Order
                </a>
            </div>
        </div>
    </div>

    <style>
        @media print {
            body * {
                visibility: hidden;
            }
            #receipt, #receipt * {
                visibility: visible;
            }
            #receipt {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                background: white !important;
                color: black !important;
                box-shadow: none !important;
                border: none !important;
            }
            #receipt .bg-gray-800\/50,
            #receipt .bg-gray-700\/30,
            #receipt .border-gray-700,
            #receipt .border-gray-600 {
                background: white !important;
                border-color: #ccc !important;
            }
            #receipt .text-white {
                color: black !important;
            }
            #receipt .text-gray-400,
            #receipt .text-gray-300 {
                color: #666 !important;
            }
            #receipt .text-amber-400 {
                color: #f59e0b !important;
            }
            #receipt .text-green-400 {
                color: #10b981 !important;
            }
            #receipt .bg-gradient-to-r {
                background: #f0f0f0 !important;
            }
        }

        .custom-scrollbar::-webkit-scrollbar {
            width: 4px;
        }

        .custom-scrollbar::-webkit-scrollbar-track {
            background: #374151;
            border-radius: 10px;
        }

        .custom-scrollbar::-webkit-scrollbar-thumb {
            background: #6B7280;
            border-radius: 10px;
        }

        .custom-scrollbar::-webkit-scrollbar-thumb:hover {
            background: #9CA3AF;
        }
    </style>

    <script>
        function printReceipt() {
            // Optional: Show a confirmation dialog
            if (confirm('Print receipt for order #<?php echo e(str_pad($transaction->id, 6, '0', STR_PAD_LEFT)); ?>?')) {
                window.print();
            }
        }

        // Auto-focus print button when page loads (optional)
        document.addEventListener('DOMContentLoaded', function() {
            // Optional: Auto-print after a short delay
            // setTimeout(() => {
            //     if (confirm('Would you like to print the receipt now?')) {
            //         printReceipt();
            //     }
            // }, 1000);
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\kasir\resources\views/kasir/order-detail.blade.php ENDPATH**/ ?>