

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
        <!-- Header -->
        <div class="flex justify-between items-center mb-8">
            <div>
                <h1 class="text-4xl font-bold text-slate-800 drop-shadow-sm">💰 Transaksi</h1>
                <p class="text-slate-600 text-lg font-medium mt-1">Kelola dan pantau semua transaksi penjualan</p>
            </div>
            <div class="flex flex-wrap gap-3">
                <a href="<?php echo e(route('admin.transactions.report')); ?>"
                    class="bg-gradient-to-r from-emerald-600 to-emerald-500 hover:from-emerald-700 hover:to-emerald-600 text-white px-6 py-3 rounded-xl text-sm font-semibold transition-all duration-300 shadow-lg hover:shadow-emerald-500/25 flex items-center space-x-2 transform hover:scale-105">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                    </svg>
                    <span>📊 Laporan</span>
                </a>
                <a href="<?php echo e(route('admin.transactions.analytics')); ?>"
                    class="bg-gradient-to-r from-violet-600 to-purple-500 hover:from-violet-700 hover:to-purple-600 text-white px-6 py-3 rounded-xl text-sm font-semibold transition-all duration-300 shadow-lg hover:shadow-violet-500/25 flex items-center space-x-2 transform hover:scale-105">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 8v8m-4-5v5m-4-2v2m-2 4h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                    <span>📈 Analytics</span>
                </a>
            </div>
        </div>

        <!-- Statistics Cards -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            <!-- Card 1 - Total Transactions -->
            <div class="bg-white rounded-xl shadow-sm hover:shadow-md transition duration-300 p-6 border border-slate-200">
                <div class="flex items-center">
                    <div class="p-3 bg-blue-100 rounded-xl mr-4">
                        <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                        </svg>
                    </div>
                    <div>
                        <p class="text-slate-600 text-sm font-medium">Total Transaksi</p>
                        <p class="text-2xl font-bold text-slate-800"><?php echo e(number_format($totalTransactions)); ?></p>
                    </div>
                </div>
            </div>

            <!-- Card 2 - Total Revenue -->
            <div class="bg-white rounded-xl shadow-sm hover:shadow-md transition duration-300 p-6 border border-slate-200">
                <div class="flex items-center">
                    <div class="p-3 bg-emerald-100 rounded-xl mr-4">
                        <svg class="w-8 h-8 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <p class="text-slate-600 text-sm font-medium">Total Revenue</p>
                        <p class="text-2xl font-bold text-slate-800">Rp <?php echo e(number_format($totalRevenue, 0, ',', '.')); ?></p>
                    </div>
                </div>
            </div>

            <!-- Card 3 - Average -->
            <div class="bg-white rounded-xl shadow-sm hover:shadow-md transition duration-300 p-6 border border-slate-200">
                <div class="flex items-center">
                    <div class="p-3 bg-violet-100 rounded-xl mr-4">
                        <svg class="w-8 h-8 text-violet-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                        </svg>
                    </div>
                    <div>
                        <p class="text-slate-600 text-sm font-medium">Rata-rata</p>
                        <p class="text-2xl font-bold text-slate-800">Rp <?php echo e($totalTransactions > 0 ? number_format($totalRevenue / $totalTransactions, 0, ',', '.') : '0'); ?></p>
                    </div>
                </div>
            </div>

            <!-- Card 4 - Today -->
            <div class="bg-white rounded-xl shadow-sm hover:shadow-md transition duration-300 p-6 border border-slate-200">
                <div class="flex items-center">
                    <div class="p-3 bg-amber-100 rounded-xl mr-4">
                        <svg class="w-8 h-8 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <p class="text-slate-600 text-sm font-medium">Hari Ini</p>
                        <p class="text-2xl font-bold text-slate-800"><?php echo e(\App\Models\Transaction::today()->count()); ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters -->
        <div class="bg-white rounded-xl shadow-sm mb-6 p-6 border border-slate-200">
            <form method="GET" action="<?php echo e(route('admin.transactions.index')); ?>">
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-6 gap-4">
                    <div>
                        <label class="block text-sm font-semibold text-slate-700 mb-2">Pencarian</label>
                        <input type="text" name="search" value="<?php echo e(request('search')); ?>" 
                               placeholder="ID atau nama kasir..."
                               class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition duration-200">
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-slate-700 mb-2">Kasir</label>
                        <select name="user_id"
                                class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition duration-200">
                            <option value="">Semua Kasir</option>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($user->id); ?>" <?php echo e(request('user_id') == $user->id ? 'selected' : ''); ?>>
                                    <?php echo e($user->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-slate-700 mb-2">Dari Tanggal</label>
                        <input type="date" name="date_from" value="<?php echo e(request('date_from')); ?>"
                               class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition duration-200">
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-slate-700 mb-2">Sampai Tanggal</label>
                        <input type="date" name="date_to" value="<?php echo e(request('date_to')); ?>"
                               class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition duration-200">
                    </div>

                    <div>
                        <label class="block text-sm font-semibold text-slate-700 mb-2">Min. Amount</label>
                        <input type="number" name="amount_min" value="<?php echo e(request('amount_min')); ?>" 
                               placeholder="0"
                               class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition duration-200">
                    </div>

                    <div class="flex items-end">
                        <div class="flex space-x-2 w-full">
                            <button type="submit"
                                    class="flex-1 bg-blue-600 hover:bg-blue-700 text-white px-4 py-3 rounded-lg font-medium transition duration-200 shadow-sm">
                                Filter
                            </button>
                            <a href="<?php echo e(route('admin.transactions.index')); ?>"
                               class="bg-slate-500 hover:bg-slate-600 text-white px-4 py-3 rounded-lg font-medium transition duration-200 shadow-sm">
                                Reset
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <!-- Export Button -->
        <?php if($transactions->count() > 0): ?>
        <div class="mb-6">
            <form method="GET" action="<?php echo e(route('admin.transactions.export')); ?>" class="inline">
                <?php $__currentLoopData = request()->except('_token'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <input type="hidden" name="<?php echo e($key); ?>" value="<?php echo e($value); ?>">
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <button type="submit"
                        class="bg-emerald-600 hover:bg-emerald-700 text-white px-6 py-3 rounded-xl text-sm font-semibold transition duration-200 flex items-center space-x-2 shadow-lg">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    <span>📥 Export CSV</span>
                </button>
            </form>
        </div>
        <?php endif; ?>

        <!-- Transactions Table -->
        <div class="bg-white rounded-xl shadow-sm overflow-hidden border border-slate-200">
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-slate-50 border-b border-slate-200">
                        <tr>
                            <th class="text-left py-4 px-6 text-slate-700 font-semibold">🆔 ID</th>
                            <th class="text-left py-4 px-6 text-slate-700 font-semibold">📅 Tanggal</th>
                            <th class="text-left py-4 px-6 text-slate-700 font-semibold">👤 Kasir</th>
                            <th class="text-left py-4 px-6 text-slate-700 font-semibold">📦 Items</th>
                            <th class="text-left py-4 px-6 text-slate-700 font-semibold">💰 Total</th>
                            <th class="text-left py-4 px-6 text-slate-700 font-semibold">💳 Pembayaran</th>
                            <th class="text-center py-4 px-6 text-slate-700 font-semibold">⚙️ Aksi</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-200">
                        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-slate-50 transition duration-200">
                            <td class="py-4 px-6">
                                <div class="flex items-center">
                                    <div class="p-2 bg-blue-100 rounded-lg mr-3">
                                        <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                        </svg>
                                    </div>
                                    <span class="text-slate-800 font-semibold">#<?php echo e($transaction->id); ?></span>
                                </div>
                            </td>
                            <td class="py-4 px-6">
                                <div class="text-slate-800 font-medium"><?php echo e($transaction->transaction_date->format('d/m/Y')); ?></div>
                                <div class="text-slate-500 text-sm"><?php echo e($transaction->transaction_date->format('H:i')); ?></div>
                            </td>
                            <td class="py-4 px-6">
                                <div class="flex items-center">
                                    <div class="w-8 h-8 bg-gradient-to-r from-blue-500 to-violet-500 rounded-lg flex items-center justify-center mr-3">
                                        <span class="text-white text-sm font-semibold"><?php echo e(substr($transaction->user->name, 0, 1)); ?></span>
                                    </div>
                                    <div>
                                        <div class="text-slate-800 font-medium"><?php echo e($transaction->user->name); ?></div>
                                        <div class="text-slate-500 text-sm">Kasir</div>
                                    </div>
                                </div>
                            </td>
                            <td class="py-4 px-6">
                                <div class="flex items-center">
                                    <div class="p-1 bg-emerald-100 rounded mr-2">
                                        <svg class="w-4 h-4 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                                        </svg>
                                    </div>
                                    <span class="text-slate-800 font-medium"><?php echo e($transaction->total_items); ?> items</span>
                                </div>
                            </td>
                            <td class="py-4 px-6">
                                <div class="text-emerald-600 font-bold text-lg"><?php echo e($transaction->formatted_total); ?></div>
                            </td>
                            <td class="py-4 px-6">
                                <div class="text-slate-800 font-medium"><?php echo e($transaction->formatted_payment); ?></div>
                                <?php if($transaction->change_amount > 0): ?>
                                    <div class="text-slate-500 text-sm">Kembalian: <?php echo e($transaction->formatted_change); ?></div>
                                <?php endif; ?>
                            </td>
                            <td class="py-4 px-6">
                                <div class="flex items-center justify-center space-x-2">
                                    <a href="<?php echo e(route('admin.transactions.show', $transaction)); ?>"
                                       class="bg-blue-600 hover:bg-blue-700 text-white p-2 rounded-lg transition duration-200 shadow-sm" 
                                       title="Lihat Detail">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                        </svg>
                                    </a>
                                    
                                    <a href="<?php echo e(route('admin.transactions.print', $transaction)); ?>" target="_blank"
                                       class="bg-violet-600 hover:bg-violet-700 text-white p-2 rounded-lg transition duration-200 shadow-sm"
                                       title="Print Receipt">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
                                        </svg>
                                    </a>

                                    <?php if($transaction->transaction_date->isToday()): ?>
                                    <form action="<?php echo e(route('admin.transactions.destroy', $transaction)); ?>" method="POST" class="inline" onsubmit="return confirm('Yakin ingin menghapus transaksi ini?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" 
                                                class="bg-red-500 hover:bg-red-600 text-white p-2 rounded-lg transition duration-200 shadow-sm"
                                                title="Hapus Transaksi">
                                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                            </svg>
                                        </button>
                                    </form>
                                    <?php endif; ?>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="7" class="py-12 px-6 text-center">
                                <div class="flex flex-col items-center">
                                    <div class="text-6xl mb-4">📋</div>
                                    <h3 class="text-lg font-semibold text-slate-700 mb-2">Tidak ada transaksi</h3>
                                    <p class="text-slate-500">Belum ada transaksi yang sesuai dengan filter yang dipilih</p>
                                </div>
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <?php if($transactions->hasPages()): ?>
            <div class="px-6 py-4 border-t border-slate-200 bg-slate-50">
                <?php echo e($transactions->appends(request()->query())->links()); ?>

            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\kasir\resources\views/admin/transactions/index.blade.php ENDPATH**/ ?>