

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
        <!-- Header -->
        <div class="flex justify-between items-center mb-8">
            <div>
                <h1 class="text-4xl font-bold text-slate-800 drop-shadow-sm">📦 Produk</h1>
                <p class="text-slate-600 text-lg font-medium mt-1">Kelola produk dan inventori</p>
            </div>
            <a href="<?php echo e(route('admin.product.create')); ?>" 
               class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded-xl font-semibold transition-all duration-300 shadow-lg hover:shadow-blue-500/25 flex items-center space-x-2 transform hover:scale-105">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                </svg>
                <span>Tambah Produk</span>
            </a>
        </div>

        <!-- Filters -->
        <div class="bg-white rounded-xl border border-slate-200 shadow-sm mb-6 p-6">
            <form method="GET" action="<?php echo e(route('admin.product.index')); ?>" class="flex flex-wrap gap-4">
                <div class="flex-1 min-w-64">
                    <label class="block text-sm font-semibold text-slate-700 mb-2">Pencarian Produk</label>
                    <input type="text" 
                           name="search" 
                           value="<?php echo e(request('search')); ?>"
                           placeholder="Nama produk atau deskripsi..." 
                           class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition duration-200">
                </div>
                <div class="min-w-48">
                    <label class="block text-sm font-semibold text-slate-700 mb-2">Kategori</label>
                    <select name="category_id" class="w-full px-4 py-3 border border-slate-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-blue-500 focus:border-transparent transition duration-200">
                        <option value="">Semua Kategori</option>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($category->id); ?>" <?php echo e(request('category_id') == $category->id ? 'selected' : ''); ?>>
                                <?php echo e($category->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="flex items-end space-x-2">
                    <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded-lg font-medium transition duration-200 shadow-sm">
                        Filter
                    </button>
                    <?php if(request('search') || request('category_id')): ?>
                        <a href="<?php echo e(route('admin.product.index')); ?>" class="bg-slate-500 hover:bg-slate-600 text-white px-6 py-3 rounded-lg font-medium transition duration-200 shadow-sm">
                            Reset
                        </a>
                    <?php endif; ?>
                </div>
            </form>
        </div>

        <!-- Products Grid -->
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-3">
            <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="bg-white rounded-lg border border-slate-200 shadow-sm hover:shadow-md transition-all duration-300 overflow-hidden max-w-xs">
                <!-- Product Image -->
                <div class="aspect-square bg-slate-100 overflow-hidden relative group">
                    <?php if($product->image): ?>
                        <img src="<?php echo e(asset('storage/' . $product->image)); ?>" 
                             alt="<?php echo e($product->name); ?>" 
                             class="w-full h-full object-cover group-hover:scale-105 transition-transform duration-300">
                    <?php else: ?>
                        <div class="w-full h-full flex items-center justify-center">
                            <svg class="w-8 h-8 text-slate-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                            </svg>
                        </div>
                    <?php endif; ?>
                    <!-- Stock Status Badge -->
                    <?php if($product->stock <= 10): ?>
                        <div class="absolute top-1.5 right-1.5">
                            <span class="inline-flex items-center px-1.5 py-0.5 rounded-full text-xs font-semibold bg-red-100 text-red-700 border border-red-200">
                                Stok Rendah
                            </span>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Product Info -->
                <div class="p-3">
                    <div class="mb-2">
                        <h3 class="font-semibold text-slate-800 text-xs line-clamp-2 mb-1 leading-tight"><?php echo e($product->name); ?></h3>
                        <p class="text-xs text-slate-500"><?php echo e($product->category->name); ?></p>
                    </div>
                    
                    <?php if($product->description): ?>
                        <p class="text-xs text-slate-600 mb-2 line-clamp-1"><?php echo e(Str::limit($product->description, 40)); ?></p>
                    <?php endif; ?>
                    
                    <div class="flex justify-between items-center mb-2">
                        <span class="text-sm font-bold text-emerald-600">
                            Rp <?php echo e(number_format($product->price / 1000, 0)); ?>k
                        </span>
                        <div class="flex items-center space-x-1">
                            <div class="p-0.5 bg-slate-100 rounded">
                                <svg class="w-2.5 h-2.5 text-slate-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                                </svg>
                            </div>
                            <span class="text-xs text-slate-600 font-medium"><?php echo e($product->stock); ?></span>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="grid grid-cols-3 gap-1">
                        <a href="<?php echo e(route('admin.product.show', $product)); ?>" 
                           class="bg-slate-100 hover:bg-slate-200 text-slate-700 text-center py-1.5 rounded text-xs font-medium transition duration-200"
                           title="Detail">
                            <svg class="w-3 h-3 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                            </svg>
                        </a>
                        <a href="<?php echo e(route('admin.product.edit', $product)); ?>" 
                           class="bg-blue-600 hover:bg-blue-700 text-white text-center py-1.5 rounded text-xs font-medium transition duration-200"
                           title="Edit">
                            <svg class="w-3 h-3 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                            </svg>
                        </a>
                        <form action="<?php echo e(route('admin.product.destroy', $product)); ?>" 
                              method="POST" 
                              class="inline" 
                              onsubmit="return confirm('Yakin ingin menghapus produk ini?')">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" 
                                    class="w-full bg-red-500 hover:bg-red-600 text-white py-1.5 rounded text-xs font-medium transition duration-200"
                                    title="Hapus">
                                <svg class="w-3 h-3 mx-auto" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                </svg>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <!-- Empty State -->
            <div class="col-span-full bg-white rounded-xl border border-slate-200 shadow-sm p-12 text-center">
                <div class="max-w-md mx-auto">
                    <div class="p-4 bg-slate-100 rounded-full inline-block mb-4">
                        <svg class="w-12 h-12 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                        </svg>
                    </div>
                    <h3 class="text-xl font-semibold text-slate-800 mb-2">
                        <?php if(request('search') || request('category_id')): ?>
                            🔍 Tidak ada produk ditemukan
                        <?php else: ?>
                            📦 Belum ada produk
                        <?php endif; ?>
                    </h3>
                    <p class="text-slate-600 mb-6">
                        <?php if(request('search') || request('category_id')): ?>
                            Coba ubah kata kunci pencarian atau filter kategori Anda
                        <?php else: ?>
                            Mulai dengan menambahkan produk pertama untuk inventori toko Anda
                        <?php endif; ?>
                    </p>
                    <?php if(!request('search') && !request('category_id')): ?>
                        <a href="<?php echo e(route('admin.product.create')); ?>" 
                           class="inline-flex items-center px-6 py-3 bg-blue-600 hover:bg-blue-700 border border-transparent rounded-xl font-semibold text-white transition-all duration-300 shadow-lg hover:shadow-blue-500/25 transform hover:scale-105">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                            </svg>
                            Tambah Produk Pertama
                        </a>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
        </div>

        <!-- Pagination -->
        <?php if($products->hasPages()): ?>
        <div class="mt-8 flex justify-center">
            <div class="bg-white rounded-xl border border-slate-200 shadow-sm p-4">
                <?php echo e($products->appends(request()->query())->links()); ?>

            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<!-- Custom CSS for line-clamp and compact layout -->
<style>
.line-clamp-1 {
    display: -webkit-box;
    -webkit-line-clamp: 1;
    -webkit-box-orient: vertical;
    overflow: hidden;
}

.line-clamp-2 {
    display: -webkit-box;
    -webkit-line-clamp: 2;
    -webkit-box-orient: vertical;
    overflow: hidden;
}

/* Ensure 4 columns on large screens */
@media (min-width: 1024px) {
    .grid-cols-4 > * {
        max-width: calc(25% - 0.75rem);
    }
}
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\kasir\resources\views/admin/product/index.blade.php ENDPATH**/ ?>