<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\KasirController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\ProductController;
use App\Http\Controllers\Admin\TransactionController;
use App\Http\Controllers\Admin\UserController;
use Illuminate\Support\Facades\Route;

// Public routes
Route::get('/', function () {
    return redirect('/login');
});

Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::get('/register', [AuthController::class, 'showRegister'])->name('register');
Route::post('/register', [AuthController::class, 'register']);

// Protected routes
Route::middleware('auth')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

    // Kasir routes
    Route::prefix('kasir')->name('kasir.')->group(function () {
        Route::get('/dashboard', [KasirController::class, 'dashboard'])->name('dashboard');
        Route::post('/add-to-cart', [KasirController::class, 'addToCart'])->name('add-to-cart');
        Route::post('/update-cart', [KasirController::class, 'updateCart'])->name('update-cart');
        Route::post('/remove-from-cart', [KasirController::class, 'removeFromCart'])->name('remove-from-cart');
        Route::post('/clear-cart', [KasirController::class, 'clearCart'])->name('clear-cart');
        Route::post('/process-transaction', [KasirController::class, 'processTransaction'])->name('process-transaction');

        // Transaction processing and order detail
        Route::post('/kasir/process-transaction', [KasirController::class, 'processTransaction'])->name('kasir.process-transaction');
        Route::get('/kasir/order/{id}', [KasirController::class, 'orderDetail'])->name('order-detail');
    });

    // Admin routes (using middleware)
    Route::middleware('admin')->prefix('admin')->name('admin.')->group(function () {

        // Dashboard
        Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

        // Categories Management
        Route::prefix('categories')->name('categories.')->group(function () {
            Route::get('/', [CategoryController::class, 'index'])->name('index');
            Route::get('/create', [CategoryController::class, 'create'])->name('create');
            Route::post('/', [CategoryController::class, 'store'])->name('store');
            Route::get('/{category}', [CategoryController::class, 'show'])->name('show');
            Route::get('/{category}/edit', [CategoryController::class, 'edit'])->name('edit');
            Route::put('/{category}', [CategoryController::class, 'update'])->name('update');
            Route::delete('/{category}', [CategoryController::class, 'destroy'])->name('destroy');
            Route::post('/bulk-delete', [CategoryController::class, 'bulkDelete'])->name('bulk-delete');
        });

        // Products Management
        Route::prefix('products')->name('product.')->group(function () {
            Route::get('/', [ProductController::class, 'index'])->name('index');
            Route::get('/create', [ProductController::class, 'create'])->name('create');
            Route::post('/', [ProductController::class, 'store'])->name('store');
            Route::get('/{product}', [ProductController::class, 'show'])->name('show');
            Route::get('/{product}/edit', [ProductController::class, 'edit'])->name('edit');
            Route::put('/{product}', [ProductController::class, 'update'])->name('update');
            Route::delete('/{product}', [ProductController::class, 'destroy'])->name('destroy');
            Route::post('/bulk-update-stock', [ProductController::class, 'bulkUpdateStock'])->name('bulk-update-stock');
            Route::get('/export/csv', [ProductController::class, 'export'])->name('export');
        });

        // Transactions Management
        Route::prefix('transactions')->name('transactions.')->group(function () {
            Route::get('/', [TransactionController::class, 'index'])->name('index');
            Route::get('/{transaction}', [TransactionController::class, 'show'])->name('show');
            Route::delete('/{transaction}', [TransactionController::class, 'destroy'])->name('destroy');
            Route::get('/report/sales', [TransactionController::class, 'report'])->name('report');
            Route::get('/analytics/dashboard', [TransactionController::class, 'analytics'])->name('analytics');
            Route::get('/export/csv', [TransactionController::class, 'export'])->name('export');
            Route::get('/{transaction}/print', [TransactionController::class, 'printReceipt'])->name('print');
            Route::get('/{transaction}/receipt', [TransactionController::class, 'receipt'])->name('receipt');
        });
    });
});
