@extends('layouts.app')

@section('content')
    <div class="min-h-screen bg-gradient-to-br from-gray-900 via-gray-800 to-gray-900">
        <!-- Header -->
        <div class="bg-gray-800/90 backdrop-blur-sm border-b border-gray-700 shadow-xl">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between items-center h-16">
                    <div class="flex items-center space-x-4">
                        <div class="flex items-center space-x-3">
                            <div class="w-10 h-10 rounded-xl flex items-center justify-center overflow-hidden">
                                 <img src="{{ asset('images/koprol.png') }}" alt="Koprol Coffee Logo" class="w-full h-full object-cover rounded-xl">
                            </div>
                            <div>
                                <h1 class="text-xl font-bold text-white">Koprol Coffee</h1>
                                <p class="text-xs text-gray-300">Selamat Bekerja kasir</p>
                            </div>
                        </div>
                        <div
                            class="px-3 py-1.5 bg-gradient-to-r from-blue-600 to-blue-700 text-white text-sm rounded-full font-medium">
                            <svg class="w-4 h-4 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                            </svg>
                            {{ Auth::user()->name }}
                        </div>
                    </div>
                    <div class="flex items-center space-x-3">
                        @if (Auth::user()->role === 'admin')
                            <a href="{{ route('admin.dashboard') }}"
                                class="bg-gradient-to-r from-purple-600 to-purple-700 hover:from-purple-700 hover:to-purple-800 text-white px-4 py-2 rounded-lg text-sm font-medium transition-all duration-300 shadow-lg hover:shadow-purple-500/25">
                                <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z">
                                    </path>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                </svg>
                                Admin Panel
                            </a>
                        @endif
                        <form action="{{ route('logout') }}" method="POST" class="inline">
                            @csrf
                            <button type="submit"
                                class="bg-gradient-to-r from-red-600 to-red-700 hover:from-red-700 hover:to-red-800 text-white px-4 py-2 rounded-lg text-sm font-medium transition-all duration-300 shadow-lg hover:shadow-red-500/25">
                                <svg class="w-4 h-4 inline mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1">
                                    </path>
                                </svg>
                                Logout
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
            <!-- Alert Messages -->
            @if (session('success'))
                <div
                    class="mb-6 bg-gradient-to-r from-green-500 to-green-600 text-white px-6 py-4 rounded-xl shadow-lg border border-green-400">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        {{ session('success') }}
                    </div>
                </div>
            @endif

            @if (session('error'))
                <div
                    class="mb-6 bg-gradient-to-r from-red-500 to-red-600 text-white px-6 py-4 rounded-xl shadow-lg border border-red-400">
                    <div class="flex items-center">
                        <svg class="w-5 h-5 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        {{ session('error') }}
                    </div>
                </div>
            @endif

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Products Section -->
                <div class="lg:col-span-2">
                    <div class="bg-gray-800/50 backdrop-blur-sm rounded-2xl shadow-2xl border border-gray-700">
                        <div class="p-6 border-b border-gray-700">
                            <div class="flex items-center justify-between mb-4">
                                <h2 class="text-xl font-bold text-white flex items-center">
                                    <svg class="w-6 h-6 mr-3 text-amber-500" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10">
                                        </path>
                                    </svg>
                                    Menu Items
                                </h2>
                                <div class="text-sm text-gray-400">
                                    {{ count($products) }} items available
                                </div>
                            </div>

                            <!-- Category Filter -->
                            <form method="GET" action="{{ route('kasir.dashboard') }}" id="category-form">
                                <div class="flex flex-wrap gap-2">
                                    <input type="submit" name="category" value=""
                                        class="category-filter {{ !request('category') ? 'active' : '' }} px-4 py-2 rounded-xl text-sm font-medium transition-all duration-300 cursor-pointer border-0 {{ !request('category') ? 'bg-gradient-to-r from-amber-500 to-orange-600 text-white shadow-lg shadow-amber-500/25' : 'bg-gray-700 text-gray-300 hover:bg-gray-600' }}">
                                    @if (!request('category'))
                                        <button type="button"
                                            class="category-filter active px-4 py-2 bg-gradient-to-r from-amber-500 to-orange-600 text-white rounded-xl text-sm font-medium shadow-lg shadow-amber-500/25">
                                            All Items
                                        </button>
                                    @else
                                        <button type="submit" name="category" value=""
                                            class="category-filter px-4 py-2 bg-gray-700 text-gray-300 hover:bg-gray-600 rounded-xl text-sm font-medium transition-all duration-300">
                                            All Items
                                        </button>
                                    @endif

                                    @foreach ($categories as $category)
                                        @if (request('category') == $category->id)
                                            <button type="button"
                                                class="category-filter active px-4 py-2 bg-gradient-to-r from-amber-500 to-orange-600 text-white rounded-xl text-sm font-medium shadow-lg shadow-amber-500/25">
                                                {{ $category->name }}
                                            </button>
                                        @else
                                            <button type="submit" name="category" value="{{ $category->id }}"
                                                class="category-filter px-4 py-2 bg-gray-700 text-gray-300 hover:bg-gray-600 rounded-xl text-sm font-medium transition-all duration-300">
                                                {{ $category->name }}
                                            </button>
                                        @endif
                                    @endforeach
                                </div>
                            </form>
                        </div>

                        <!-- Products Grid -->
                        <div class="p-6">
                            <div class="grid grid-cols-2 sm:grid-cols-3 xl:grid-cols-4 gap-4">
                                @forelse($products as $product)
                                    <form action="{{ route('kasir.add-to-cart') }}" method="POST" class="product-card">
                                        @csrf
                                        <input type="hidden" name="product_id" value="{{ $product->id }}">
                                        <button type="submit"
                                            class="w-full bg-gray-700/50 hover:bg-gray-600/50 border border-gray-600 hover:border-amber-500/50 rounded-xl p-4 transition-all duration-300 hover:shadow-xl hover:shadow-amber-500/10 group {{ $product->stock <= 0 ? 'opacity-50 cursor-not-allowed' : '' }}"
                                            {{ $product->stock <= 0 ? 'disabled' : '' }}>
                                            <div
                                                class="aspect-square bg-gradient-to-br from-gray-800 to-gray-900 rounded-lg mb-3 flex items-center justify-center overflow-hidden group-hover:scale-105 transition-transform duration-300">
                                                @if ($product->image)
                                                    <img src="{{ asset('storage/' . $product->image) }}"
                                                        alt="{{ $product->name }}"
                                                        class="w-full h-full object-cover rounded-lg">
                                                @else
                                                    <svg class="w-8 h-8 text-gray-500" fill="none"
                                                        stroke="currentColor" viewBox="0 0 24 24">
                                                        <path stroke-linecap="round" stroke-linejoin="round"
                                                            stroke-width="2"
                                                            d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10">
                                                        </path>
                                                    </svg>
                                                @endif
                                            </div>
                                            <h3
                                                class="font-semibold text-sm text-white mb-1 group-hover:text-amber-400 transition-colors duration-300">
                                                {{ $product->name }}</h3>
                                            <p class="text-amber-400 font-bold text-sm mb-1">Rp
                                                {{ number_format($product->price, 0, ',', '.') }}</p>
                                            <p
                                                class="text-xs {{ $product->stock <= 5 ? 'text-red-400' : 'text-gray-400' }}">
                                                @if ($product->stock <= 0)
                                                    Out of Stock
                                                @elseif($product->stock <= 5)
                                                    Low Stock: {{ $product->stock }}
                                                @else
                                                    Stock: {{ $product->stock }}
                                                @endif
                                            </p>
                                        </button>
                                    </form>
                                @empty
                                    <div class="col-span-full text-center py-12">
                                        <svg class="w-16 h-16 mx-auto mb-4 text-gray-600" fill="none"
                                            stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10">
                                            </path>
                                        </svg>
                                        <p class="text-gray-400 text-lg font-medium">No products available</p>
                                        <p class="text-gray-500 text-sm">Try a different category or check back later</p>
                                    </div>
                                @endforelse
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Cart Section -->
                <div class="lg:col-span-1">
                    <div
                        class="bg-gray-800/50 backdrop-blur-sm rounded-2xl shadow-2xl border border-gray-700 sticky top-6">
                        <div class="p-6 border-b border-gray-700">
                            <h2 class="text-xl font-bold text-white flex items-center">
                                <svg class="w-6 h-6 mr-3 text-green-500" fill="none" stroke="currentColor"
                                    viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                        d="M3 3h2l.4 2M7 13h10l4-8H5.4m0 0L7 13m0 0l-1.5 6M7 13l-1.5-6M20 13v6a2 2 0 01-2 2H6a2 2 0 01-2-2v-6">
                                    </path>
                                </svg>
                                Order Summary
                            </h2>
                        </div>

                        <form action="{{ route('kasir.process-transaction') }}" method="POST">
                            @csrf
                            <div class="p-6">
                                <!-- Cart Items -->
                                <div class="space-y-3 mb-6 max-h-64 overflow-y-auto custom-scrollbar">
                                    @php $cartItems = session('cart', []); @endphp
                                    @if (empty($cartItems))
                                        <div class="text-center text-gray-400 py-8">
                                            <svg class="w-12 h-12 mx-auto mb-3 text-gray-600" fill="none"
                                                stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M3 3h2l.4 2M7 13h10l4-8H5.4m0 0L7 13m0 0l-1.5 6M7 13l-1.5-6M20 13v6a2 2 0 01-2 2H6a2 2 0 01-2-2v-6">
                                                </path>
                                            </svg>
                                            <p class="text-sm font-medium">Your cart is empty</p>
                                            <p class="text-xs text-gray-500">Add items to get started</p>
                                        </div>
                                    @else
                                        @foreach ($cartItems as $index => $item)
                                            <div
                                                class="flex items-center justify-between bg-gray-700/30 p-4 rounded-xl border border-gray-600">
                                                <div class="flex-1">
                                                    <h4 class="font-semibold text-sm text-white">{{ $item['name'] }}</h4>
                                                    <p class="text-xs text-gray-400">Rp
                                                        {{ number_format($item['price'], 0, ',', '.') }}</p>
                                                </div>
                                                <div class="flex items-center space-x-3">
                                                    <form action="{{ route('kasir.update-cart') }}" method="POST"
                                                        class="inline">
                                                        @csrf
                                                        <input type="hidden" name="index"
                                                            value="{{ $index }}">
                                                        <input type="hidden" name="action" value="decrease">
                                                        <button type="submit"
                                                            class="w-7 h-7 flex items-center justify-center bg-gray-600 hover:bg-gray-500 rounded-lg text-white text-sm font-bold transition-colors duration-200">-</button>
                                                    </form>

                                                    <span
                                                        class="w-8 text-center text-sm font-semibold text-white">{{ $item['quantity'] }}</span>

                                                    <form action="{{ route('kasir.update-cart') }}" method="POST"
                                                        class="inline">
                                                        @csrf
                                                        <input type="hidden" name="index"
                                                            value="{{ $index }}">
                                                        <input type="hidden" name="action" value="increase">
                                                        <button type="submit"
                                                            class="w-7 h-7 flex items-center justify-center bg-gray-600 hover:bg-gray-500 rounded-lg text-white text-sm font-bold transition-colors duration-200">+</button>
                                                    </form>

                                                    <form action="{{ route('kasir.remove-from-cart') }}" method="POST"
                                                        class="inline">
                                                        @csrf
                                                        <input type="hidden" name="index"
                                                            value="{{ $index }}">
                                                        <button type="submit"
                                                            class="w-7 h-7 flex items-center justify-center bg-red-600 hover:bg-red-500 rounded-lg text-white text-sm font-bold transition-colors duration-200">×</button>
                                                    </form>
                                                </div>
                                            </div>

                                            <input type="hidden" name="items[{{ $index }}][product_id]"
                                                value="{{ $item['product_id'] }}">
                                            <input type="hidden" name="items[{{ $index }}][quantity]"
                                                value="{{ $item['quantity'] }}">
                                        @endforeach
                                    @endif
                                </div>

                                <!-- Total Calculation -->
                                @php
                                    $subtotal = 0;
                                    foreach ($cartItems as $item) {
                                        $subtotal += $item['price'] * $item['quantity'];
                                    }
                                @endphp

                                <div class="border-t border-gray-700 pt-4 space-y-4">
                                    <div class="flex justify-between text-gray-300">
                                        <span>Subtotal:</span>
                                        <span class="font-semibold">Rp {{ number_format($subtotal, 0, ',', '.') }}</span>
                                    </div>
                                    <div
                                        class="flex justify-between font-bold text-lg text-white border-t border-gray-700 pt-3">
                                        <span>Total:</span>
                                        <span class="text-amber-400">Rp {{ number_format($subtotal, 0, ',', '.') }}</span>
                                    </div>

                                    <!-- Payment Input -->
                                    <div class="space-y-3 pt-4">
                                        <label class="block text-sm font-semibold text-gray-300">Payment Amount</label>
                                        <input type="number" name="payment_amount" id="payment_amount"
                                            class="w-full px-4 py-3 bg-gray-700 border border-gray-600 rounded-xl focus:outline-none focus:ring-2 focus:ring-amber-500 focus:border-amber-500 text-white placeholder-gray-400"
                                            placeholder="Enter amount" min="{{ $subtotal }}" step="1000"
                                            onchange="calculateChange({{ $subtotal }})" required>

                                        <div class="flex justify-between text-sm text-gray-300">
                                            <span>Change:</span>
                                            <span id="change" class="font-semibold text-green-400">Rp 0</span>
                                        </div>
                                    </div>

                                    <input type="hidden" name="total_amount" value="{{ $subtotal }}">

                                    <!-- Action Buttons -->
                                    <div class="space-y-3 pt-4">
                                        @if (!empty($cartItems))
                                            <button type="submit"
                                                class="w-full bg-gradient-to-r from-green-600 to-green-700 hover:from-green-700 hover:to-green-800 text-white py-3 rounded-xl font-semibold transition-all duration-300 shadow-lg hover:shadow-green-500/25">
                                                <svg class="w-5 h-5 inline mr-2" fill="none" stroke="currentColor"
                                                    viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z">
                                                    </path>
                                                </svg>
                                                Process Payment
                                            </button>
                                        @endif

                                        <form action="{{ route('kasir.clear-cart') }}" method="POST" class="w-full">
                                            @csrf
                                            <button type="submit"
                                                class="w-full bg-gradient-to-r from-gray-600 to-gray-700 hover:from-gray-700 hover:to-gray-800 text-white py-3 rounded-xl font-semibold transition-all duration-300">
                                                <svg class="w-5 h-5 inline mr-2" fill="none" stroke="currentColor"
                                                    viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                        d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16">
                                                    </path>
                                                </svg>
                                                Clear Cart
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .custom-scrollbar::-webkit-scrollbar {
            width: 4px;
        }

        .custom-scrollbar::-webkit-scrollbar-track {
            background: #374151;
            border-radius: 10px;
        }

        .custom-scrollbar::-webkit-scrollbar-thumb {
            background: #6B7280;
            border-radius: 10px;
        }

        .custom-scrollbar::-webkit-scrollbar-thumb:hover {
            background: #9CA3AF;
        }
    </style>

    <script>
        function calculateChange(total) {
            const payment = parseFloat(document.getElementById('payment_amount').value) || 0;
            const change = payment - total;

            document.getElementById('change').textContent = 'Rp ' + new Intl.NumberFormat('id-ID').format(Math.max(0,
                change));
        }
    </script>
@endsection
