@extends('admin.layouts.app')

@section('content')
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100 p-6">
    <!-- Header -->
    <div class="mb-8">
        <div class="flex items-center justify-between">
            <div class="flex items-center space-x-4">
                <a href="{{ route('admin.transactions.index') }}" 
                   class="bg-white hover:bg-slate-50 border border-slate-200 text-slate-700 p-3 rounded-xl transition-all duration-300 shadow-sm hover:shadow-md">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                    </svg>
                </a>
                <div>
                    <h1 class="text-4xl font-bold text-slate-800 drop-shadow-sm">📄 Detail Transaksi</h1>
                    <p class="text-slate-600 text-lg font-medium mt-1">ID Transaksi: #{{ $transaction->id }}</p>
                </div>
            </div>
            <div class="flex space-x-3">
                <a href="{{ route('admin.transactions.receipt', $transaction) }}" target="_blank"
                   class="bg-gradient-to-r from-emerald-600 to-emerald-700 hover:from-emerald-700 hover:to-emerald-800 text-white px-6 py-3 rounded-xl text-sm font-semibold transition-all duration-300 shadow-lg hover:shadow-emerald-500/25 flex items-center space-x-2 transform hover:scale-105">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 17h2a2 2 0 002-2v-4a2 2 0 00-2-2H5a2 2 0 00-2 2v4a2 2 0 002 2h2m2 4h6a2 2 0 002-2v-4a2 2 0 00-2-2H9a2 2 0 00-2 2v4a2 2 0 002 2zm8-12V5a2 2 0 00-2-2H9a2 2 0 00-2 2v4h10z"></path>
                    </svg>
                    <span>🖨️ Print Receipt</span>
                </a>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <!-- Transaction Info -->
        <div class="lg:col-span-2 space-y-8">
            <!-- Basic Info Card -->
            <div class="bg-white rounded-xl border border-slate-200 shadow-sm p-6">
                <div class="flex items-center justify-between mb-6">
                    <h2 class="text-xl font-bold text-slate-800">ℹ️ Informasi Transaksi</h2>
                    <div class="flex items-center space-x-2">
                        <div class="w-3 h-3 bg-emerald-500 rounded-full"></div>
                        <span class="text-emerald-600 font-semibold">Completed</span>
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="space-y-4">
                        <div class="flex items-center space-x-3">
                            <div class="p-3 bg-blue-100 rounded-xl">
                                <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                                </svg>
                            </div>
                            <div>
                                <p class="text-slate-500 text-sm font-medium">ID Transaksi</p>
                                <p class="text-slate-800 font-bold">#{{ $transaction->id }}</p>
                            </div>
                        </div>

                        <div class="flex items-center space-x-3">
                            <div class="p-3 bg-violet-100 rounded-xl">
                                <svg class="w-5 h-5 text-violet-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                                </svg>
                            </div>
                            <div>
                                <p class="text-slate-500 text-sm font-medium">Kasir</p>
                                <p class="text-slate-800 font-bold">{{ $transaction->user->name }}</p>
                            </div>
                        </div>
                    </div>

                    <div class="space-y-4">
                        <div class="flex items-center space-x-3">
                            <div class="p-3 bg-orange-100 rounded-xl">
                                <svg class="w-5 h-5 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3a2 2 0 012-2h4a2 2 0 012 2v4m-6 0a2 2 0 00-2 2v6a2 2 0 002 2h8a2 2 0 002-2V9a2 2 0 00-2-2H8a2 2 0 00-2 2z"></path>
                                </svg>
                            </div>
                            <div>
                                <p class="text-slate-500 text-sm font-medium">Tanggal</p>
                                <p class="text-slate-800 font-bold">{{ $transaction->transaction_date->format('d F Y') }}</p>
                            </div>
                        </div>

                        <div class="flex items-center space-x-3">
                            <div class="p-3 bg-emerald-100 rounded-xl">
                                <svg class="w-5 h-5 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                            </div>
                            <div>
                                <p class="text-slate-500 text-sm font-medium">Waktu</p>
                                <p class="text-slate-800 font-bold">{{ $transaction->transaction_date->format('H:i:s') }}</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Items List -->
            <div class="bg-white rounded-xl border border-slate-200 shadow-sm overflow-hidden">
                <div class="p-6 border-b border-slate-200">
                    <div class="flex items-center justify-between">
                        <h2 class="text-xl font-bold text-slate-800">🛍️ Item Pembelian</h2>
                        <div class="bg-violet-100 px-4 py-2 rounded-xl">
                            <span class="text-violet-600 font-semibold">{{ $transaction->items->count() }} Items</span>
                        </div>
                    </div>
                </div>

                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-slate-50 border-b border-slate-200">
                            <tr>
                                <th class="text-left py-4 px-6 text-slate-700 font-semibold">Produk</th>
                                <th class="text-center py-4 px-6 text-slate-700 font-semibold">Qty</th>
                                <th class="text-right py-4 px-6 text-slate-700 font-semibold">Harga</th>
                                <th class="text-right py-4 px-6 text-slate-700 font-semibold">Subtotal</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-slate-200">
                            @foreach($transaction->items as $item)
                            <tr class="hover:bg-slate-50 transition-colors duration-200">
                                <td class="py-4 px-6">
                                    <div class="flex items-center space-x-4">
                                        @if($item->product->image)
                                        <img src="{{ Storage::url($item->product->image) }}" 
                                             alt="{{ $item->product->name }}"
                                             class="w-12 h-12 rounded-xl object-cover border-2 border-slate-200">
                                        @else
                                        <div class="w-12 h-12 bg-slate-100 rounded-xl flex items-center justify-center border-2 border-slate-200">
                                            <svg class="w-6 h-6 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                                            </svg>
                                        </div>
                                        @endif
                                        <div>
                                            <h3 class="text-slate-800 font-semibold">{{ $item->product->name }}</h3>
                                            <p class="text-slate-500 text-sm">{{ $item->product->category->name ?? 'Uncategorized' }}</p>
                                        </div>
                                    </div>
                                </td>
                                <td class="py-4 px-6 text-center">
                                    <div class="bg-blue-100 px-3 py-2 rounded-xl inline-block">
                                        <span class="text-blue-600 font-bold">{{ $item->quantity }}x</span>
                                    </div>
                                </td>
                                <td class="py-4 px-6 text-right">
                                    <span class="text-slate-600 font-semibold">{{ $item->formatted_price }}</span>
                                </td>
                                <td class="py-4 px-6 text-right">
                                    <span class="text-emerald-600 font-bold text-lg">{{ $item->formatted_subtotal }}</span>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Summary Sidebar -->
        <div class="lg:col-span-1">
            <div class="sticky top-6 space-y-6">
                <!-- Payment Summary -->
                <div class="bg-white rounded-xl border border-slate-200 shadow-sm p-6">
                    <h2 class="text-xl font-bold text-slate-800 mb-6 flex items-center">
                        <svg class="w-6 h-6 mr-2 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        💰 Ringkasan Pembayaran
                    </h2>

                    <div class="space-y-4">
                        <div class="flex justify-between items-center py-2 border-b border-slate-200">
                            <span class="text-slate-500 font-medium">Subtotal ({{ $transaction->items->sum('quantity') }} items)</span>
                            <span class="text-slate-800 font-semibold">{{ $transaction->formatted_total }}</span>
                        </div>

                        <div class="flex justify-between items-center py-2 border-b border-slate-200">
                            <span class="text-slate-500 font-medium">Pajak</span>
                            <span class="text-slate-800 font-semibold">Rp 0</span>
                        </div>

                        <div class="flex justify-between items-center py-3 border-b-2 border-slate-300">
                            <span class="text-lg font-bold text-slate-800">Total</span>
                            <span class="text-2xl font-bold text-emerald-600">{{ $transaction->formatted_total }}</span>
                        </div>

                        <div class="bg-blue-50 border border-blue-200 rounded-xl p-4">
                            <div class="flex justify-between items-center mb-2">
                                <span class="text-blue-700 font-semibold">💵 Dibayar</span>
                                <span class="text-slate-800 font-bold">{{ $transaction->formatted_payment }}</span>
                            </div>
                            @if($transaction->change_amount > 0)
                            <div class="flex justify-between items-center">
                                <span class="text-orange-700 font-semibold">💸 Kembalian</span>
                                <span class="text-orange-600 font-bold">{{ $transaction->formatted_change }}</span>
                            </div>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Transaction Stats -->
                <div class="bg-white rounded-xl border border-slate-200 shadow-sm p-6">
                    <h2 class="text-xl font-bold text-slate-800 mb-6 flex items-center">
                        <svg class="w-6 h-6 mr-2 text-violet-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                        </svg>
                        📊 Statistik
                    </h2>

                    <div class="grid grid-cols-2 gap-4">
                        <div class="bg-emerald-50 border border-emerald-200 rounded-xl p-4 text-center">
                            <div class="text-2xl font-bold text-emerald-600 mb-1">{{ $transaction->items->count() }}</div>
                            <div class="text-emerald-700 text-sm font-medium">Jenis Item</div>
                        </div>
                        
                        <div class="bg-blue-50 border border-blue-200 rounded-xl p-4 text-center">
                            <div class="text-2xl font-bold text-blue-600 mb-1">{{ $transaction->items->sum('quantity') }}</div>
                            <div class="text-blue-700 text-sm font-medium">Total Qty</div>
                        </div>

                        <div class="bg-orange-50 border border-orange-200 rounded-xl p-4 text-center col-span-2">
                            <div class="text-lg font-bold text-orange-600 mb-1">
                                Rp {{ number_format($transaction->total_amount / $transaction->items->sum('quantity'), 0, ',', '.') }}
                            </div>
                            <div class="text-orange-700 text-sm font-medium">Rata-rata per Item</div>
                        </div>
                    </div>
                </div>

                <!-- Actions -->
                @if($transaction->transaction_date->isToday())
                <div class="bg-red-50 border border-red-200 rounded-xl p-6 shadow-sm">
                    <h3 class="text-lg font-bold text-red-700 mb-4">⚠️ Danger Zone</h3>
                    <p class="text-red-600 text-sm mb-4 font-medium">Hapus transaksi ini secara permanen. Stok produk akan dikembalikan.</p>
                    <form action="{{ route('admin.transactions.destroy', $transaction) }}" method="POST" onsubmit="return confirm('Yakin ingin menghapus transaksi ini? Stok produk akan dikembalikan.')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" 
                                class="w-full bg-gradient-to-r from-red-600 to-red-700 hover:from-red-700 hover:to-red-800 text-white py-3 px-4 rounded-xl font-semibold transition-all duration-300 shadow-lg hover:shadow-red-500/25 transform hover:scale-105">
                            🗑️ Hapus Transaksi
                        </button>
                    </form>
                </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection