@extends('admin.layouts.app')

@section('content')
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100 p-6">
    <!-- Header -->
    <div class="mb-8">
        <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4">
            <div class="flex items-center space-x-4">
                <a href="{{ route('admin.transactions.index') }}" 
                   class="bg-white hover:bg-slate-50 border border-slate-200 text-slate-700 p-3 rounded-xl transition-all duration-300 shadow-sm hover:shadow-md">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                    </svg>
                </a>
                <div>
                    <h1 class="text-3xl font-bold text-slate-800 mb-2">📊 Laporan Penjualan</h1>
                    <p class="text-slate-600">Periode: {{ \Carbon\Carbon::parse($dateFrom)->format('d M Y') }} - {{ \Carbon\Carbon::parse($dateTo)->format('d M Y') }}</p>
                </div>
            </div>
            <div class="flex flex-wrap gap-3">
                <form method="GET" action="{{ route('admin.transactions.export') }}" class="inline">
                    <input type="hidden" name="date_from" value="{{ $dateFrom }}">
                    <input type="hidden" name="date_to" value="{{ $dateTo }}">
                    <button type="submit"
                            class="bg-emerald-600 hover:bg-emerald-700 text-white px-6 py-3 rounded-xl text-sm font-semibold transition-all duration-300 shadow-lg hover:shadow-emerald-500/25 flex items-center space-x-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        <span>Export CSV</span>
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Date Range Filter -->
    <div class="bg-white rounded-xl border border-slate-200 p-6 mb-8 shadow-sm">
        <form method="GET" action="{{ route('admin.transactions.report') }}">
            <div class="flex flex-col md:flex-row gap-4 items-end">
                <div class="flex-1">
                    <label class="block text-sm font-semibold text-slate-700 mb-2">Dari Tanggal</label>
                    <input type="date" name="date_from" value="{{ $dateFrom }}"
                           class="w-full bg-white border border-slate-300 text-slate-800 rounded-xl px-4 py-3 focus:outline-none focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 transition-all duration-300">
                </div>
                <div class="flex-1">
                    <label class="block text-sm font-semibold text-slate-700 mb-2">Sampai Tanggal</label>
                    <input type="date" name="date_to" value="{{ $dateTo }}"
                           class="w-full bg-white border border-slate-300 text-slate-800 rounded-xl px-4 py-3 focus:outline-none focus:border-blue-500 focus:ring-2 focus:ring-blue-500/20 transition-all duration-300">
                </div>
                <button type="submit"
                        class="bg-blue-600 hover:bg-blue-700 text-white px-8 py-3 rounded-xl text-sm font-semibold transition-all duration-300 shadow-lg flex items-center space-x-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                    </svg>
                    <span>Update</span>
                </button>
            </div>
        </form>
    </div>

    <!-- Summary Statistics -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <div class="bg-white rounded-xl border border-slate-200 p-6 shadow-sm hover:shadow-md transition duration-300">
            <div class="flex items-center">
                <div class="p-3 bg-blue-100 rounded-xl mr-4">
                    <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <p class="text-slate-600 text-sm font-medium">Total Transaksi</p>
                    <p class="text-2xl font-bold text-slate-800">{{ number_format($summary['total_transactions']) }}</p>
                    <p class="text-blue-500 text-xs mt-1">+{{ number_format(($summary['total_transactions'] / max(1, \Carbon\Carbon::parse($dateFrom)->diffInDays(\Carbon\Carbon::parse($dateTo)) ?: 1)), 1) }}/hari</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl border border-slate-200 p-6 shadow-sm hover:shadow-md transition duration-300">
            <div class="flex items-center">
                <div class="p-3 bg-emerald-100 rounded-xl mr-4">
                    <svg class="w-8 h-8 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <p class="text-slate-600 text-sm font-medium">Total Revenue</p>
                    <p class="text-2xl font-bold text-slate-800">Rp {{ number_format($summary['total_revenue'], 0, ',', '.') }}</p>
                    <p class="text-emerald-500 text-xs mt-1">Revenue period</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl border border-slate-200 p-6 shadow-sm hover:shadow-md transition duration-300">
            <div class="flex items-center">
                <div class="p-3 bg-violet-100 rounded-xl mr-4">
                    <svg class="w-8 h-8 text-violet-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <p class="text-slate-600 text-sm font-medium">Rata-rata Transaksi</p>
                    <p class="text-2xl font-bold text-slate-800">Rp {{ number_format($summary['average_transaction'], 0, ',', '.') }}</p>
                    <p class="text-violet-500 text-xs mt-1">Per transaksi</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl border border-slate-200 p-6 shadow-sm hover:shadow-md transition duration-300">
            <div class="flex items-center">
                <div class="p-3 bg-amber-100 rounded-xl mr-4">
                    <svg class="w-8 h-8 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <p class="text-slate-600 text-sm font-medium">Items Terjual</p>
                    <p class="text-2xl font-bold text-slate-800">{{ number_format($summary['total_items_sold']) }}</p>
                    <p class="text-amber-500 text-xs mt-1">Total items</p>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
        <!-- Daily Sales Chart -->
        <div class="bg-white rounded-xl border border-slate-200 p-6 shadow-sm">
            <h3 class="text-xl font-bold text-slate-800 mb-6 flex items-center">
                <svg class="w-6 h-6 mr-2 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                </svg>
                Penjualan Harian
            </h3>
            
            <div class="space-y-4 max-h-80 overflow-y-auto">
                @forelse($dailySales as $daily)
                <div class="flex items-center justify-between p-4 bg-slate-50 rounded-xl hover:bg-slate-100 transition-colors duration-200">
                    <div class="flex items-center space-x-3">
                        <div class="p-2 bg-blue-100 rounded-lg">
                            <svg class="w-5 h-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3a2 2 0 012-2h4a2 2 0 012 2v4m-6 0a2 2 0 00-2 2v6a2 2 0 002 2h8a2 2 0 002-2V9a2 2 0 00-2-2H8a2 2 0 00-2 2z"></path>
                            </svg>
                        </div>
                        <div>
                            <p class="text-slate-800 font-semibold">{{ \Carbon\Carbon::parse($daily->date)->format('d M Y') }}</p>
                            <p class="text-slate-500 text-sm">{{ $daily->count }} transaksi</p>
                        </div>
                    </div>
                    <div class="text-right">
                        <p class="text-emerald-600 font-bold">Rp {{ number_format($daily->revenue, 0, ',', '.') }}</p>
                        <div class="w-32 bg-slate-200 rounded-full h-2 mt-1">
                            <div class="bg-gradient-to-r from-emerald-500 to-blue-500 h-2 rounded-full transition-all duration-500"
                                 style="width: {{ $dailySales->max('revenue') > 0 ? ($daily->revenue / $dailySales->max('revenue')) * 100 : 0 }}%"></div>
                        </div>
                    </div>
                </div>
                @empty
                <div class="text-center py-8">
                    <div class="p-4 bg-slate-100 rounded-full inline-block mb-4">
                        <svg class="w-8 h-8 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                        </svg>
                    </div>
                    <p class="text-slate-500">Tidak ada data penjualan</p>
                </div>
                @endforelse
            </div>
        </div>

        <!-- Sales by User -->
        <div class="bg-white rounded-xl border border-slate-200 p-6 shadow-sm">
            <h3 class="text-xl font-bold text-slate-800 mb-6 flex items-center">
                <svg class="w-6 h-6 mr-2 text-violet-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                </svg>
                Performa Kasir
            </h3>
            
            <div class="space-y-4 max-h-80 overflow-y-auto">
                @forelse($salesByUser as $userSale)
                <div class="flex items-center justify-between p-4 bg-slate-50 rounded-xl hover:bg-slate-100 transition-colors duration-200">
                    <div class="flex items-center space-x-3">
                        <div class="w-10 h-10 bg-gradient-to-r from-violet-500 to-purple-600 rounded-xl flex items-center justify-center">
                            <span class="text-white font-semibold text-sm">{{ substr($userSale->user->name, 0, 1) }}</span>
                        </div>
                        <div>
                            <p class="text-slate-800 font-semibold">{{ $userSale->user->name }}</p>
                            <p class="text-slate-500 text-sm">{{ $userSale->count }} transaksi</p>
                        </div>
                    </div>
                    <div class="text-right">
                        <p class="text-emerald-600 font-bold">Rp {{ number_format($userSale->revenue, 0, ',', '.') }}</p>
                        <div class="w-32 bg-slate-200 rounded-full h-2 mt-1">
                            <div class="bg-gradient-to-r from-violet-500 to-purple-500 h-2 rounded-full transition-all duration-500"
                                 style="width: {{ $salesByUser->max('revenue') > 0 ? ($userSale->revenue / $salesByUser->max('revenue')) * 100 : 0 }}%"></div>
                        </div>
                    </div>
                </div>
                @empty
                <div class="text-center py-8">
                    <div class="p-4 bg-slate-100 rounded-full inline-block mb-4">
                        <svg class="w-8 h-8 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                        </svg>
                    </div>
                    <p class="text-slate-500">Tidak ada data kasir</p>
                </div>
                @endforelse
            </div>
        </div>
    </div>

    <!-- Top Products -->
    <div class="bg-white rounded-xl border border-slate-200 shadow-sm overflow-hidden">
        <div class="p-6 border-b border-slate-200 bg-slate-50">
            <h3 class="text-xl font-bold text-slate-800 flex items-center">
                <svg class="w-6 h-6 mr-2 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                </svg>
                Top 10 Produk Terlaris
            </h3>
        </div>

        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-slate-50 border-b border-slate-200">
                    <tr>
                        <th class="text-left py-4 px-6 text-slate-700 font-semibold">Rank</th>
                        <th class="text-left py-4 px-6 text-slate-700 font-semibold">Produk</th>
                        <th class="text-center py-4 px-6 text-slate-700 font-semibold">Qty Terjual</th>
                        <th class="text-right py-4 px-6 text-slate-700 font-semibold">Revenue</th>
                        <th class="text-center py-4 px-6 text-slate-700 font-semibold">Persentase</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-slate-200">
                    @forelse($topProducts as $index => $product)
                    <tr class="hover:bg-slate-50 transition-colors duration-200">
                        <td class="py-4 px-6">
                            <div class="flex items-center">
                                @if($index < 3)
                                <div class="p-2 {{ $index == 0 ? 'bg-yellow-100' : ($index == 1 ? 'bg-slate-200' : 'bg-amber-100') }} rounded-lg">
                                    <svg class="w-5 h-5 {{ $index == 0 ? 'text-yellow-600' : ($index == 1 ? 'text-slate-500' : 'text-amber-600') }}" fill="currentColor" viewBox="0 0 20 20">
                                        <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"></path>
                                    </svg>
                                </div>
                                @else
                                <div class="p-2 bg-slate-100 rounded-lg">
                                    <span class="text-slate-600 font-bold text-sm">#{{ $index + 1 }}</span>
                                </div>
                                @endif
                            </div>
                        </td>
                        <td class="py-4 px-6">
                            <div class="text-slate-800 font-semibold">{{ $product->name }}</div>
                        </td>
                        <td class="py-4 px-6 text-center">
                            <div class="bg-blue-100 px-3 py-1 rounded-xl inline-block">
                                <span class="text-blue-600 font-bold">{{ $product->total_quantity }}</span>
                            </div>
                        </td>
                        <td class="py-4 px-6 text-right">
                            <span class="text-emerald-600 font-bold text-lg">Rp {{ number_format($product->total_revenue, 0, ',', '.') }}</span>
                        </td>
                        <td class="py-4 px-6">
                            <div class="flex items-center justify-center">
                                <div class="w-24 bg-slate-200 rounded-full h-2">
                                    <div class="bg-gradient-to-r from-emerald-500 to-blue-500 h-2 rounded-full transition-all duration-500"
                                         style="width: {{ $topProducts->max('total_quantity') > 0 ? ($product->total_quantity / $topProducts->max('total_quantity')) * 100 : 0 }}%"></div>
                                </div>
                                <span class="text-slate-600 text-sm ml-2">
                                    {{ $topProducts->sum('total_quantity') > 0 ? number_format(($product->total_quantity / $topProducts->sum('total_quantity')) * 100, 1) : 0 }}%
                                </span>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="py-12 px-6 text-center">
                            <div class="flex flex-col items-center">
                                <div class="p-4 bg-slate-100 rounded-full mb-4">
                                    <svg class="w-12 h-12 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                                    </svg>
                                </div>
                                <h3 class="text-lg font-semibold text-slate-700 mb-2">Tidak ada data produk</h3>
                                <p class="text-slate-500">Belum ada produk yang terjual dalam periode ini</p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection