<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Receipt - Transaksi #{{ $transaction->id }}</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Courier New', monospace;
            font-size: 12px;
            line-height: 1.4;
            color: #000;
            background: white;
            width: 80mm; /* Thermal printer width */
            margin: 0 auto;
            padding: 10px;
        }

        .receipt {
            width: 100%;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px dashed #000;
            padding-bottom: 15px;
        }

        .store-name {
            font-size: 18px;
            font-weight: bold;
            text-transform: uppercase;
            margin-bottom: 5px;
        }

        .store-address {
            font-size: 10px;
            margin-bottom: 3px;
        }

        .transaction-info {
            margin-bottom: 15px;
            font-size: 10px;
        }

        .transaction-info div {
            display: flex;
            justify-content: space-between;
            margin-bottom: 2px;
        }

        .items-table {
            width: 100%;
            margin-bottom: 15px;
        }

        .items-header {
            border-bottom: 1px solid #000;
            padding-bottom: 5px;
            margin-bottom: 5px;
            font-weight: bold;
            font-size: 10px;
        }

        .item-row {
            margin-bottom: 8px;
            font-size: 10px;
        }

        .item-name {
            font-weight: bold;
            margin-bottom: 2px;
        }

        .item-details {
            display: flex;
            justify-content: space-between;
            color: #555;
        }

        .totals {
            border-top: 1px solid #000;
            padding-top: 10px;
            margin-bottom: 15px;
        }

        .total-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 3px;
            font-size: 11px;
        }

        .total-row.final {
            font-weight: bold;
            font-size: 14px;
            border-top: 1px dashed #000;
            padding-top: 5px;
            margin-top: 8px;
        }

        .payment-info {
            margin-bottom: 20px;
            font-size: 11px;
        }

        .payment-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 3px;
        }

        .footer {
            text-align: center;
            border-top: 2px dashed #000;
            padding-top: 15px;
            font-size: 10px;
        }

        .thank-you {
            font-weight: bold;
            margin-bottom: 10px;
            text-transform: uppercase;
        }

        .contact-info {
            margin-bottom: 5px;
        }

        /* Print styles */
        @media print {
            body {
                width: 80mm;
                margin: 0;
                padding: 5px;
            }
            
            .no-print {
                display: none;
            }
        }

        /* Print button */
        .print-button {
            position: fixed;
            top: 20px;
            right: 20px;
            background: #2563eb;
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 8px;
            font-weight: bold;
            cursor: pointer;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            transition: background-color 0.2s;
        }

        .print-button:hover {
            background: #1d4ed8;
        }

        .dotted-line {
            border-bottom: 1px dotted #000;
            margin: 10px 0;
        }

        .center {
            text-align: center;
        }

        .bold {
            font-weight: bold;
        }

        .small {
            font-size: 9px;
        }
    </style>
</head>
<body>
    <!-- Print Button -->
    <button class="print-button no-print" onclick="window.print()">
        🖨️ Print Receipt
    </button>

    <div class="receipt">
        <!-- Header -->
        <div class="header">
            <div class="store-name">TOKO KUE MANIS</div>
            <div class="store-address">Jl. Manis Raya No. 123</div>
            <div class="store-address">Jakarta Selatan 12345</div>
            <div class="store-address">Telp: (021) 123-4567</div>
        </div>

        <!-- Transaction Info -->
        <div class="transaction-info">
            <div>
                <span>No. Transaksi</span>
                <span>#{{ $transaction->id }}</span>
            </div>
            <div>
                <span>Kasir</span>
                <span>{{ $transaction->user->name }}</span>
            </div>
            <div>
                <span>Tanggal</span>
                <span>{{ $transaction->transaction_date->format('d/m/Y H:i:s') }}</span>
            </div>
        </div>

        <div class="dotted-line"></div>

        <!-- Items -->
        <div class="items-table">
            <div class="items-header">
                DAFTAR PEMBELIAN
            </div>

            @foreach($transaction->items as $item)
            <div class="item-row">
                <div class="item-name">{{ $item->product->name }}</div>
                <div class="item-details">
                    <span>{{ $item->quantity }} x {{ number_format($item->price, 0, ',', '.') }}</span>
                    <span>{{ number_format($item->subtotal, 0, ',', '.') }}</span>
                </div>
            </div>
            @endforeach
        </div>

        <!-- Totals -->
        <div class="totals">
            <div class="total-row">
                <span>Subtotal ({{ $transaction->items->sum('quantity') }} items)</span>
                <span>{{ number_format($transaction->total_amount, 0, ',', '.') }}</span>
            </div>
            <div class="total-row">
                <span>Pajak</span>
                <span>0</span>
            </div>
            <div class="total-row">
                <span>Diskon</span>
                <span>0</span>
            </div>
            <div class="total-row final">
                <span>TOTAL</span>
                <span>{{ number_format($transaction->total_amount, 0, ',', '.') }}</span>
            </div>
        </div>

        <!-- Payment Info -->
        <div class="payment-info">
            <div class="payment-row bold">
                <span>Tunai</span>
                <span>{{ number_format($transaction->payment_amount, 0, ',', '.') }}</span>
            </div>
            @if($transaction->change_amount > 0)
            <div class="payment-row bold">
                <span>Kembalian</span>
                <span>{{ number_format($transaction->change_amount, 0, ',', '.') }}</span>
            </div>
            @endif
        </div>

        <div class="dotted-line"></div>

        <!-- Footer -->
        <div class="footer">
            <div class="thank-you">Terima Kasih!</div>
            <div class="contact-info">Barang yang sudah dibeli</div>
            <div class="contact-info">tidak dapat dikembalikan</div>
            <div class="dotted-line"></div>
            <div class="small">{{ now()->format('d/m/Y H:i:s') }}</div>
            <div class="small">Sistem Kasir POS</div>
        </div>
    </div>

    <script>
        // Auto print when page loads
        window.onload = function() {
            // Small delay to ensure page is fully rendered
            setTimeout(() => {
                // Uncomment the line below if you want auto-print
                // window.print();
            }, 500);
        };

        // Close window after printing
        window.onafterprint = function() {
            // Uncomment the line below if you want to close window after print
            // window.close();
        };
    </script>
</body>
</html>