@extends('admin.layouts.app')

@section('content')
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100 p-6">
    <!-- Header -->
    <div class="mb-8">
        <div class="flex flex-col lg:flex-row lg:items-center lg:justify-between gap-4">
            <div class="flex items-center space-x-4">
                <a href="{{ route('admin.transactions.index') }}" 
                   class="bg-white hover:bg-slate-50 border border-slate-200 text-slate-700 p-3 rounded-xl transition-all duration-300 shadow-sm hover:shadow-md">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                    </svg>
                </a>
                <div>
                    <h1 class="text-3xl font-bold text-slate-800 mb-2">📈 Analytics Dashboard</h1>
                    <p class="text-slate-600">Analisis mendalam tentang performa penjualan dan tren bisnis</p>
                </div>
            </div>
            <div class="flex items-center space-x-2 text-sm text-slate-500">
                <div class="flex items-center space-x-1">
                    <div class="w-3 h-3 bg-emerald-500 rounded-full animate-pulse"></div>
                    <span>Live Data</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Quick Stats -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        @php
            $todayTransactions = \App\Models\Transaction::today()->count();
            $todayRevenue = \App\Models\Transaction::today()->sum('total_amount');
            $monthlyTransactions = \App\Models\Transaction::thisMonth()->count();
            $monthlyRevenue = \App\Models\Transaction::thisMonth()->sum('total_amount');
        @endphp

        <div class="bg-white rounded-xl border border-slate-200 p-6 shadow-sm hover:shadow-md transition duration-300">
            <div class="flex items-center">
                <div class="p-3 bg-blue-100 rounded-xl mr-4">
                    <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 3v1m0 16v1m9-9h-1M4 12H3m15.364 6.364l-.707-.707M6.343 6.343l-.707-.707m12.728 0l-.707.707M6.343 17.657l-.707.707M16 12a4 4 0 11-8 0 4 4 0 018 0z"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <p class="text-slate-600 text-sm font-medium">Transaksi Hari Ini</p>
                    <p class="text-2xl font-bold text-slate-800">{{ number_format($todayTransactions) }}</p>
                    <p class="text-blue-500 text-xs mt-1">{{ now()->format('d M Y') }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl border border-slate-200 p-6 shadow-sm hover:shadow-md transition duration-300">
            <div class="flex items-center">
                <div class="p-3 bg-emerald-100 rounded-xl mr-4">
                    <svg class="w-8 h-8 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <p class="text-slate-600 text-sm font-medium">Revenue Hari Ini</p>
                    <p class="text-2xl font-bold text-slate-800">Rp {{ number_format($todayRevenue, 0, ',', '.') }}</p>
                    <p class="text-emerald-500 text-xs mt-1">Target harian</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl border border-slate-200 p-6 shadow-sm hover:shadow-md transition duration-300">
            <div class="flex items-center">
                <div class="p-3 bg-violet-100 rounded-xl mr-4">
                    <svg class="w-8 h-8 text-violet-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3a2 2 0 012-2h4a2 2 0 012 2v4m-6 0a2 2 0 00-2 2v6a2 2 0 002 2h8a2 2 0 002-2V9a2 2 0 00-2-2H8a2 2 0 00-2 2z"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <p class="text-slate-600 text-sm font-medium">Transaksi Bulan Ini</p>
                    <p class="text-2xl font-bold text-slate-800">{{ number_format($monthlyTransactions) }}</p>
                    <p class="text-violet-500 text-xs mt-1">{{ now()->format('M Y') }}</p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-xl border border-slate-200 p-6 shadow-sm hover:shadow-md transition duration-300">
            <div class="flex items-center">
                <div class="p-3 bg-amber-100 rounded-xl mr-4">
                    <svg class="w-8 h-8 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                    </svg>
                </div>
                <div class="flex-1">
                    <p class="text-slate-600 text-sm font-medium">Revenue Bulan Ini</p>
                    <p class="text-2xl font-bold text-slate-800">Rp {{ number_format($monthlyRevenue, 0, ',', '.') }}</p>
                    <p class="text-amber-500 text-xs mt-1">Target bulanan</p>
                </div>
            </div>
        </div>
    </div>

    <!-- Charts Row -->
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
        <!-- Revenue Trend (Last 30 Days) -->
        <div class="bg-white rounded-xl border border-slate-200 p-6 shadow-sm">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-xl font-bold text-slate-800 flex items-center">
                    <svg class="w-6 h-6 mr-2 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                    </svg>
                    Tren Revenue 30 Hari
                </h3>
                <div class="text-slate-500 text-sm">{{ $revenueTrend->count() }} hari data</div>
            </div>

            <div class="space-y-3 max-h-80 overflow-y-auto">
                @forelse($revenueTrend as $trend)
                <div class="flex items-center justify-between p-3 bg-slate-50 rounded-xl hover:bg-slate-100 transition-colors duration-200">
                    <div class="flex items-center space-x-3">
                        <div class="p-2 bg-blue-100 rounded-lg">
                            <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3a2 2 0 012-2h4a2 2 0 012 2v4m-6 0a2 2 0 00-2 2v6a2 2 0 002 2h8a2 2 0 002-2V9a2 2 0 00-2-2H8a2 2 0 00-2 2z"></path>
                            </svg>
                        </div>
                        <div>
                            <p class="text-slate-800 font-semibold">{{ \Carbon\Carbon::parse($trend->date)->format('d M') }}</p>
                            <p class="text-slate-500 text-xs">{{ \Carbon\Carbon::parse($trend->date)->format('l') }}</p>
                        </div>
                    </div>
                    <div class="text-right">
                        <p class="text-emerald-600 font-bold">Rp {{ number_format($trend->revenue, 0, ',', '.') }}</p>
                        <div class="w-24 bg-slate-200 rounded-full h-1.5 mt-1">
                            <div class="bg-gradient-to-r from-emerald-500 to-blue-500 h-1.5 rounded-full transition-all duration-500"
                                 style="width: {{ $revenueTrend->max('revenue') > 0 ? ($trend->revenue / $revenueTrend->max('revenue')) * 100 : 0 }}%"></div>
                        </div>
                    </div>
                </div>
                @empty
                <div class="text-center py-8">
                    <div class="p-4 bg-slate-100 rounded-full inline-block mb-4">
                        <svg class="w-8 h-8 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                        </svg>
                    </div>
                    <p class="text-slate-500">Belum ada data revenue</p>
                </div>
                @endforelse
            </div>
        </div>

        <!-- Hourly Sales Pattern -->
        <div class="bg-white rounded-xl border border-slate-200 p-6 shadow-sm">
            <div class="flex items-center justify-between mb-6">
                <h3 class="text-xl font-bold text-slate-800 flex items-center">
                    <svg class="w-6 h-6 mr-2 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    Pola Penjualan Per Jam
                </h3>
                <div class="text-slate-500 text-sm">Hari ini</div>
            </div>

            <div class="space-y-3 max-h-80 overflow-y-auto">
                @forelse($hourlySales->sortBy('hour') as $hourly)
                <div class="flex items-center justify-between p-3 bg-slate-50 rounded-xl hover:bg-slate-100 transition-colors duration-200">
                    <div class="flex items-center space-x-3">
                        <div class="p-2 bg-amber-100 rounded-lg">
                            <svg class="w-4 h-4 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                        </div>
                        <div>
                            <p class="text-slate-800 font-semibold">{{ str_pad($hourly->hour, 2, '0', STR_PAD_LEFT) }}:00</p>
                            <p class="text-slate-500 text-xs">{{ $hourly->count }} transaksi</p>
                        </div>
                    </div>
                    <div class="text-right">
                        <p class="text-emerald-600 font-bold">Rp {{ number_format($hourly->revenue, 0, ',', '.') }}</p>
                        <div class="w-24 bg-slate-200 rounded-full h-1.5 mt-1">
                            <div class="bg-gradient-to-r from-amber-500 to-orange-500 h-1.5 rounded-full transition-all duration-500"
                                 style="width: {{ $hourlySales->max('revenue') > 0 ? ($hourly->revenue / $hourlySales->max('revenue')) * 100 : 0 }}%"></div>
                        </div>
                    </div>
                </div>
                @empty
                <div class="text-center py-8">
                    <div class="p-4 bg-slate-100 rounded-full inline-block mb-4">
                        <svg class="w-8 h-8 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <p class="text-slate-500">Belum ada transaksi hari ini</p>
                </div>
                @endforelse
            </div>
        </div>
    </div>

    <!-- Category Performance -->
    <div class="bg-white rounded-xl border border-slate-200 shadow-sm overflow-hidden">
        <div class="p-6 border-b border-slate-200 bg-slate-50">
            <div class="flex items-center justify-between">
                <h3 class="text-xl font-bold text-slate-800 flex items-center">
                    <svg class="w-6 h-6 mr-2 text-violet-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                    </svg>
                    Performa Kategori (Bulan Ini)
                </h3>
                <div class="text-slate-500 text-sm">{{ $categoryPerformance->count() }} kategori</div>
            </div>
        </div>

        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-slate-50 border-b border-slate-200">
                    <tr>
                        <th class="text-left py-4 px-6 text-slate-700 font-semibold">Kategori</th>
                        <th class="text-center py-4 px-6 text-slate-700 font-semibold">Qty Terjual</th>
                        <th class="text-right py-4 px-6 text-slate-700 font-semibold">Revenue</th>
                        <th class="text-center py-4 px-6 text-slate-700 font-semibold">Kontribusi</th>
                        <th class="text-center py-4 px-6 text-slate-700 font-semibold">Trend</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-slate-200">
                    @forelse($categoryPerformance as $category)
                    <tr class="hover:bg-slate-50 transition-colors duration-200">
                        <td class="py-4 px-6">
                            <div class="flex items-center space-x-3">
                                <div class="p-2 bg-violet-100 rounded-lg">
                                    <svg class="w-5 h-5 text-violet-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                                    </svg>
                                </div>
                                <div>
                                    <p class="text-slate-800 font-semibold">{{ $category->name }}</p>
                                    <p class="text-slate-500 text-sm">Kategori produk</p>
                                </div>
                            </div>
                        </td>
                        <td class="py-4 px-6 text-center">
                            <div class="bg-blue-100 px-3 py-1 rounded-xl inline-block">
                                <span class="text-blue-600 font-bold">{{ number_format($category->total_quantity) }}</span>
                            </div>
                        </td>
                        <td class="py-4 px-6 text-right">
                            <span class="text-emerald-600 font-bold text-lg">Rp {{ number_format($category->total_revenue, 0, ',', '.') }}</span>
                        </td>
                        <td class="py-4 px-6">
                            <div class="flex flex-col items-center">
                                <div class="w-full bg-slate-200 rounded-full h-2 mb-2">
                                    <div class="bg-gradient-to-r from-emerald-500 to-blue-500 h-2 rounded-full transition-all duration-500"
                                         style="width: {{ $categoryPerformance->max('total_revenue') > 0 ? ($category->total_revenue / $categoryPerformance->max('total_revenue')) * 100 : 0 }}%"></div>
                                </div>
                                <span class="text-slate-600 text-sm">
                                    {{ $categoryPerformance->sum('total_revenue') > 0 ? number_format(($category->total_revenue / $categoryPerformance->sum('total_revenue')) * 100, 1) : 0 }}%
                                </span>
                            </div>
                        </td>
                        <td class="py-4 px-6 text-center">
                            <div class="flex items-center justify-center space-x-1 text-emerald-600">
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                                </svg>
                                <span class="text-sm font-medium">Naik</span>
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="py-12 px-6 text-center">
                            <div class="flex flex-col items-center">
                                <div class="p-4 bg-slate-100 rounded-full mb-4">
                                    <svg class="w-12 h-12 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                                    </svg>
                                </div>
                                <h3 class="text-lg font-semibold text-slate-700 mb-2">Tidak ada data kategori</h3>
                                <p class="text-slate-500">Belum ada penjualan produk bulan ini</p>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Insights Panel -->
    <div class="mt-8 grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Peak Hours -->
        <div class="bg-gradient-to-r from-blue-50 to-blue-100 border border-blue-200 rounded-xl p-6">
            <div class="flex items-center space-x-3 mb-4">
                <div class="p-2 bg-blue-500 rounded-lg">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <h4 class="text-lg font-bold text-slate-800">⏰ Jam Tersibuk</h4>
            </div>
            @if($hourlySales->count() > 0)
            @php $peakHour = $hourlySales->sortByDesc('revenue')->first(); @endphp
            <p class="text-blue-600 text-2xl font-bold mb-2">{{ str_pad($peakHour->hour, 2, '0', STR_PAD_LEFT) }}:00</p>
            <p class="text-slate-600 text-sm">Revenue: Rp {{ number_format($peakHour->revenue, 0, ',', '.') }}</p>
            <p class="text-slate-600 text-sm">{{ $peakHour->count }} transaksi</p>
            @else
            <p class="text-slate-500 text-sm">Belum ada data hari ini</p>
            @endif
        </div>

        <!-- Best Category -->
        <div class="bg-gradient-to-r from-emerald-50 to-emerald-100 border border-emerald-200 rounded-xl p-6">
            <div class="flex items-center space-x-3 mb-4">
                <div class="p-2 bg-emerald-500 rounded-lg">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"></path>
                    </svg>
                </div>
                <h4 class="text-lg font-bold text-slate-800">🏆 Top Kategori</h4>
            </div>
            @if($categoryPerformance->count() > 0)
            @php $topCategory = $categoryPerformance->sortByDesc('total_revenue')->first(); @endphp
            <p class="text-emerald-600 text-lg font-bold mb-2">{{ $topCategory->name }}</p>
            <p class="text-slate-600 text-sm">Revenue: Rp {{ number_format($topCategory->total_revenue, 0, ',', '.') }}</p>
            <p class="text-slate-600 text-sm">{{ number_format($topCategory->total_quantity) }} items terjual</p>
            @else
            <p class="text-slate-500 text-sm">Belum ada data bulan ini</p>
            @endif
        </div>

        <!-- Growth Indicator -->
        <div class="bg-gradient-to-r from-amber-50 to-amber-100 border border-amber-200 rounded-xl p-6">
            <div class="flex items-center space-x-3 mb-4">
                <div class="p-2 bg-amber-500 rounded-lg">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                    </svg>
                </div>
                <h4 class="text-lg font-bold text-slate-800">📊 Tren Bulan Ini</h4>
            </div>
            @php
                $previousMonth = \App\Models\Transaction::whereMonth('transaction_date', now()->subMonth()->month)
                    ->whereYear('transaction_date', now()->subMonth()->year)
                    ->sum('total_amount');
                $currentMonth = $monthlyRevenue;
                $growth = $previousMonth > 0 ? (($currentMonth - $previousMonth) / $previousMonth) * 100 : 0;
            @endphp
            <div class="flex items-center space-x-2">
                @if($growth >= 0)
                <svg class="w-5 h-5 text-emerald-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path>
                </svg>
                <p class="text-emerald-600 text-2xl font-bold">+{{ number_format($growth, 1) }}%</p>
                @else
                <svg class="w-5 h-5 text-red-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 17h8m0 0V9m0 8l-8-8-4 4-6-6"></path>
                </svg>
                <p class="text-red-600 text-2xl font-bold">{{ number_format($growth, 1) }}%</p>
                @endif
            </div>
            <p class="text-slate-600 text-sm mt-2">Dibanding bulan lalu</p>
        </div>
    </div>
</div>
@endsection