@extends('admin.layouts.app')

@section('content')
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
        <!-- Header -->
        <div class="flex items-center justify-between mb-8">
            <div class="flex items-center space-x-4">
                <a href="{{ route('admin.product.index') }}" 
                   class="bg-white hover:bg-slate-50 border border-slate-200 text-slate-700 p-3 rounded-xl transition-all duration-300 shadow-sm hover:shadow-md">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                    </svg>
                </a>
                <div>
                    <h1 class="text-4xl font-bold text-slate-800 drop-shadow-sm">📦 Detail Produk</h1>
                    <p class="text-slate-600 text-lg font-medium mt-1">Informasi lengkap dan riwayat transaksi</p>
                </div>
            </div>
            <div class="flex space-x-3">
                <a href="{{ route('admin.product.edit', $product) }}" 
                   class="bg-blue-600 hover:bg-blue-700 text-white px-6 py-3 rounded-xl font-semibold transition-all duration-300 shadow-lg hover:shadow-blue-500/25 flex items-center space-x-2 transform hover:scale-105">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                    </svg>
                    <span>Edit Produk</span>
                </a>
            </div>
        </div>

        <div class="grid grid-cols-1 xl:grid-cols-5 gap-8">
            <!-- Product Details Card -->
            <div class="xl:col-span-2">
                <div class="bg-white rounded-xl border border-slate-200 shadow-sm overflow-hidden">
                    <!-- Product Image -->
                    <div class="aspect-square bg-slate-100 overflow-hidden">
                        @if($product->image)
                            <img src="{{ asset('storage/' . $product->image) }}" 
                                 alt="{{ $product->name }}" 
                                 class="w-full h-full object-cover hover:scale-105 transition-transform duration-300">
                        @else
                            <div class="w-full h-full flex items-center justify-center">
                                <svg class="w-20 h-20 text-slate-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                                </svg>
                            </div>
                        @endif
                    </div>

                    <!-- Product Info -->
                    <div class="p-6">
                        <div class="flex items-start justify-between mb-6">
                            <h2 class="text-xl font-bold text-slate-800 flex-1 pr-4">{{ $product->name }}</h2>
                            @if($product->stock == 0)
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-red-100 text-red-700 border border-red-200">
                                    Stok Habis
                                </span>
                            @elseif($product->stock <= 10)
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-amber-100 text-amber-700 border border-amber-200">
                                    Stok Rendah
                                </span>
                            @else
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-semibold bg-emerald-100 text-emerald-700 border border-emerald-200">
                                    Tersedia
                                </span>
                            @endif
                        </div>

                        <div class="grid grid-cols-1 gap-4">
                            <!-- Category -->
                            <div class="bg-slate-50 rounded-lg p-4">
                                <div class="flex items-center">
                                    <div class="p-2 bg-violet-100 rounded-lg mr-3">
                                        <svg class="w-4 h-4 text-violet-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                                        </svg>
                                    </div>
                                    <div>
                                        <p class="text-sm text-slate-500">Kategori</p>
                                        <p class="font-semibold text-slate-800">{{ $product->category->name }}</p>
                                    </div>
                                </div>
                            </div>

                            <!-- Price and Stock -->
                            <div class="grid grid-cols-2 gap-4">
                                <!-- Price -->
                                <div class="bg-emerald-50 rounded-lg p-4">
                                    <div class="flex items-center">
                                        <div class="p-2 bg-emerald-100 rounded-lg mr-3">
                                            <svg class="w-4 h-4 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                            </svg>
                                        </div>
                                        <div>
                                            <p class="text-sm text-slate-500">Harga</p>
                                            <p class="text-lg font-bold text-emerald-600">Rp {{ number_format($product->price, 0, ',', '.') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <!-- Stock -->
                                <div class="bg-blue-50 rounded-lg p-4">
                                    <div class="flex items-center">
                                        <div class="p-2 bg-blue-100 rounded-lg mr-3">
                                            <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                                            </svg>
                                        </div>
                                        <div>
                                            <p class="text-sm text-slate-500">Stok</p>
                                            <p class="text-lg font-bold text-slate-800">{{ number_format($product->stock) }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Description -->
                            @if($product->description)
                            <div class="bg-amber-50 rounded-lg p-4">
                                <div class="flex items-start">
                                    <div class="p-2 bg-amber-100 rounded-lg mr-3 mt-1">
                                        <svg class="w-4 h-4 text-amber-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                        </svg>
                                    </div>
                                    <div class="flex-1">
                                        <p class="text-sm text-slate-500 mb-1">Deskripsi</p>
                                        <p class="text-slate-700">{{ $product->description }}</p>
                                    </div>
                                </div>
                            </div>
                            @endif

                            <!-- Created Date -->
                            <div class="bg-slate-50 rounded-lg p-4">
                                <div class="flex items-center">
                                    <div class="p-2 bg-slate-200 rounded-lg mr-3">
                                        <svg class="w-4 h-4 text-slate-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3a2 2 0 012-2h4a2 2 0 012 2v4m-6 0a2 2 0 00-2 2v6a2 2 0 002 2h8a2 2 0 002-2V9a2 2 0 00-2-2H8a2 2 0 00-2 2z"></path>
                                        </svg>
                                    </div>
                                    <div>
                                        <p class="text-sm text-slate-500">Dibuat</p>
                                        <p class="font-semibold text-slate-800">{{ $product->created_at->format('d M Y, H:i') }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Transaction History -->
            <div class="xl:col-span-3">
                <div class="bg-white rounded-xl border border-slate-200 shadow-sm overflow-hidden">
                    <div class="p-6 border-b border-slate-200 bg-slate-50">
                        <div class="flex items-center justify-between">
                            <h3 class="text-xl font-bold text-slate-800 flex items-center">
                                <svg class="w-6 h-6 mr-2 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                                </svg>
                                Riwayat Transaksi
                            </h3>
                            <span class="text-sm text-slate-500 bg-white px-3 py-1 rounded-full border border-slate-200">{{ $transactionHistory->total() }} transaksi</span>
                        </div>
                    </div>

                    @if($transactionHistory->count() > 0)
                    <div class="overflow-x-auto">
                        <table class="w-full">
                            <thead class="bg-slate-50 border-b border-slate-200">
                                <tr>
                                    <th class="text-left py-4 px-6 text-slate-700 font-semibold">ID Transaksi</th>
                                    <th class="text-left py-4 px-6 text-slate-700 font-semibold">Tanggal</th>
                                    <th class="text-left py-4 px-6 text-slate-700 font-semibold">Kasir</th>
                                    <th class="text-center py-4 px-6 text-slate-700 font-semibold">Qty</th>
                                    <th class="text-right py-4 px-6 text-slate-700 font-semibold">Subtotal</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-slate-200">
                                @foreach($transactionHistory as $item)
                                <tr class="hover:bg-slate-50 transition-colors duration-200">
                                    <td class="py-4 px-6">
                                        <div class="flex items-center">
                                            <div class="p-2 bg-blue-100 rounded-lg mr-3">
                                                <svg class="w-4 h-4 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                                </svg>
                                            </div>
                                            <a href="{{ route('admin.transactions.show', $item->transaction) }}" 
                                               class="text-blue-600 hover:text-blue-800 font-semibold">
                                                #{{ $item->transaction->id }}
                                            </a>
                                        </div>
                                    </td>
                                    <td class="py-4 px-6">
                                        <div>
                                            <p class="text-slate-800 font-medium">{{ $item->transaction->transaction_date->format('d M Y') }}</p>
                                            <p class="text-slate-500 text-sm">{{ $item->transaction->transaction_date->format('H:i') }}</p>
                                        </div>
                                    </td>
                                    <td class="py-4 px-6">
                                        <div class="flex items-center">
                                            <div class="w-8 h-8 bg-gradient-to-r from-violet-500 to-purple-600 rounded-lg flex items-center justify-center mr-3">
                                                <span class="text-white text-sm font-semibold">{{ substr($item->transaction->user->name, 0, 1) }}</span>
                                            </div>
                                            <div>
                                                <p class="text-slate-800 font-medium">{{ $item->transaction->user->name }}</p>
                                                <p class="text-slate-500 text-sm">Kasir</p>
                                            </div>
                                        </div>
                                    </td>
                                    <td class="py-4 px-6 text-center">
                                        <div class="bg-emerald-100 px-3 py-1 rounded-xl inline-block">
                                            <span class="text-emerald-700 font-bold">{{ $item->quantity }}</span>
                                        </div>
                                    </td>
                                    <td class="py-4 px-6 text-right">
                                        <span class="text-emerald-600 font-bold text-lg">Rp {{ number_format($item->subtotal, 0, ',', '.') }}</span>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if($transactionHistory->hasPages())
                    <div class="px-6 py-4 border-t border-slate-200 bg-slate-50">
                        {{ $transactionHistory->links() }}
                    </div>
                    @endif

                    @else
                    <!-- No Transactions -->
                    <div class="p-12 text-center">
                        <div class="p-4 bg-slate-100 rounded-full inline-block mb-4">
                            <svg class="w-12 h-12 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                            </svg>
                        </div>
                        <h3 class="text-lg font-semibold text-slate-700 mb-2">📋 Belum Ada Transaksi</h3>
                        <p class="text-slate-500">Produk ini belum pernah dibeli dalam transaksi apapun</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection