@extends('admin.layouts.app')

@section('content')
<div class="min-h-screen bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
        <!-- Header Section -->
        <div class="mb-8">
            <div class="flex items-center justify-between mb-6">
                <div class="flex items-center space-x-4">
                    <div class="w-12 h-12 rounded-xl flex items-center justify-center overflow-hidden shadow-lg">
    <img src="{{ asset('images/koprol.png') }}" alt="Koprol Coffee Logo" class="w-full h-full object-cover rounded-xl">
</div>
                    <div>
                        <h1 class="text-4xl font-bold text-slate-800 drop-shadow-sm">Admin Dashboard</h1>
                        <p class="text-slate-600 text-lg font-medium mt-1">Selamat datang kembali, {{ Auth::user()->name }}</p>
                    </div>
                </div>
                <div class="text-right bg-white rounded-xl border border-slate-200 shadow-sm p-4">
                    <p class="text-sm text-slate-500 font-medium">{{ now()->format('l, d F Y') }}</p>
                    <p class="text-lg font-bold text-blue-600">{{ now()->format('H:i') }} WIB</p>
                </div>
            </div>
        </div>

        <!-- Stats Cards -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            <!-- Total Products -->
            <div class="bg-white rounded-xl border border-slate-200 shadow-sm p-6 hover:shadow-md transition-all duration-300 hover:border-blue-300">
                <div class="flex items-center">
                    <div class="p-4 bg-gradient-to-r from-blue-500 to-blue-600 rounded-xl shadow-lg shadow-blue-500/25">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-semibold text-slate-600">Total Produk</p>
                        <p class="text-3xl font-bold text-slate-800">{{ $totalProducts }}</p>
                        <p class="text-xs text-blue-600 mt-1 font-medium">Items tersedia</p>
                    </div>
                </div>
            </div>

            <!-- Total Categories -->
            <div class="bg-white rounded-xl border border-slate-200 shadow-sm p-6 hover:shadow-md transition-all duration-300 hover:border-emerald-300">
                <div class="flex items-center">
                    <div class="p-4 bg-gradient-to-r from-emerald-500 to-emerald-600 rounded-xl shadow-lg shadow-emerald-500/25">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-semibold text-slate-600">Total Kategori</p>
                        <p class="text-3xl font-bold text-slate-800">{{ $totalCategories }}</p>
                        <p class="text-xs text-emerald-600 mt-1 font-medium">Kategori aktif</p>
                    </div>
                </div>
            </div>

            <!-- Total Transactions -->
            <div class="bg-white rounded-xl border border-slate-200 shadow-sm p-6 hover:shadow-md transition-all duration-300 hover:border-violet-300">
                <div class="flex items-center">
                    <div class="p-4 bg-gradient-to-r from-violet-500 to-violet-600 rounded-xl shadow-lg shadow-violet-500/25">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-semibold text-slate-600">Total Transaksi</p>
                        <p class="text-3xl font-bold text-slate-800">{{ $totalTransactions }}</p>
                        <p class="text-xs text-violet-600 mt-1 font-medium">Transaksi berhasil</p>
                    </div>
                </div>
            </div>

            <!-- Total Revenue -->
            <div class="bg-white rounded-xl border border-slate-200 shadow-sm p-6 hover:shadow-md transition-all duration-300 hover:border-orange-300">
                <div class="flex items-center">
                    <div class="p-4 bg-gradient-to-r from-orange-500 to-orange-600 rounded-xl shadow-lg shadow-orange-500/25">
                        <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"></path>
                        </svg>
                    </div>
                    <div class="ml-4">
                        <p class="text-sm font-semibold text-slate-600">Total Pendapatan</p>
                        <p class="text-2xl font-bold text-slate-800">Rp {{ number_format($totalRevenue, 0, ',', '.') }}</p>
                        <p class="text-xs text-orange-600 mt-1 font-medium">Revenue</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Warning for Low Stock -->
        @if($lowStockProducts > 0)
        <div class="mb-8 bg-red-50 border border-red-200 rounded-xl shadow-sm p-6">
            <div class="flex items-center">
                <div class="p-2 bg-red-100 rounded-lg mr-4">
                    <svg class="w-6 h-6 text-red-600" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
                    </svg>
                </div>
                <div>
                    <span class="font-bold text-red-800">⚠️ Peringatan Stok!</span>
                    <p class="text-red-700 font-medium">{{ $lowStockProducts }} produk memiliki stok rendah (≤10). 
                        <a href="{{ route('admin.product.index') }}" class="underline hover:text-red-800 transition-colors duration-200 font-semibold">Lihat produk →</a>
                    </p>
                </div>
            </div>
        </div>
        @endif

        <!-- Management Tools -->
        <div class="mb-8 bg-white rounded-xl border border-slate-200 shadow-sm">
            <div class="p-6 border-b border-slate-200">
                <h2 class="text-xl font-bold text-slate-800 flex items-center">
                    <svg class="w-6 h-6 mr-3 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                    </svg>
                    🛠️ Management Tools
                </h2>
            </div>
            <div class="p-6">
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                    <a href="{{ route('admin.product.create') }}" 
                       class="bg-gradient-to-r from-blue-600 to-blue-700 hover:from-blue-700 hover:to-blue-800 text-white p-4 rounded-xl flex items-center transition-all duration-300 shadow-lg hover:shadow-blue-500/25 group transform hover:scale-105">
                        <svg class="w-6 h-6 mr-3 group-hover:scale-110 transition-transform duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        <div>
                            <span class="font-semibold text-sm">Tambah Produk</span>
                            <p class="text-xs text-blue-200">Item baru</p>
                        </div>
                    </a>
                    
                    <a href="{{ route('admin.product.index') }}" 
                       class="bg-gradient-to-r from-emerald-600 to-emerald-700 hover:from-emerald-700 hover:to-emerald-800 text-white p-4 rounded-xl flex items-center transition-all duration-300 shadow-lg hover:shadow-emerald-500/25 group transform hover:scale-105">
                        <svg class="w-6 h-6 mr-3 group-hover:scale-110 transition-transform duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                        </svg>
                        <div>
                            <span class="font-semibold text-sm">Kelola Stok</span>
                            <p class="text-xs text-emerald-200">Inventori</p>
                        </div>
                    </a>

                    <a href="#" onclick="exportReport()" 
                       class="bg-gradient-to-r from-violet-600 to-violet-700 hover:from-violet-700 hover:to-violet-800 text-white p-4 rounded-xl flex items-center transition-all duration-300 shadow-lg hover:shadow-violet-500/25 group transform hover:scale-105">
                        <svg class="w-6 h-6 mr-3 group-hover:scale-110 transition-transform duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        <div>
                            <span class="font-semibold text-sm">Export Laporan</span>
                            <p class="text-xs text-violet-200">Download</p>
                        </div>
                    </a>
                    
                    <a href="{{ route('kasir.dashboard') }}" 
                       class="bg-gradient-to-r from-orange-600 to-orange-700 hover:from-orange-700 hover:to-orange-800 text-white p-4 rounded-xl flex items-center transition-all duration-300 shadow-lg hover:shadow-orange-500/25 group transform hover:scale-105">
                        <svg class="w-6 h-6 mr-3 group-hover:scale-110 transition-transform duration-300" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4m0 0L7 13m0 0l-1.5 6M7 13l-1.5-6M20 13v6a2 2 0 01-2 2H6a2 2 0 01-2-2v-6"></path>
                        </svg>
                        <div>
                            <span class="font-semibold text-sm">Ke Kasir</span>
                            <p class="text-xs text-orange-200">Transaksi</p>
                        </div>
                    </a>
                </div>
            </div>
        </div>

        <!-- Charts Section -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
            <!-- Revenue Chart -->
            <div class="bg-white rounded-xl border border-slate-200 shadow-sm">
                <div class="p-6 border-b border-slate-200">
                    <div class="flex items-center justify-between">
                        <h2 class="text-xl font-bold text-slate-800 flex items-center">
                            <svg class="w-6 h-6 mr-3 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"></path>
                            </svg>
                            📈 Revenue {{ now()->year }}
                        </h2>
                        <div class="text-sm text-slate-500 font-semibold">
                            Rp {{ number_format($totalRevenue, 0, ',', '.') }}
                        </div>
                    </div>
                </div>
                
                <div class="p-6">
                    <canvas id="revenueChart" width="400" height="250"></canvas>
                </div>
            </div>

            <!-- Top Products Pie Chart -->
            <div class="bg-white rounded-xl border border-slate-200 shadow-sm">
                <div class="p-6 border-b border-slate-200">
                    <h2 class="text-xl font-bold text-slate-800 flex items-center">
                        <svg class="w-6 h-6 mr-3 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11.049 2.927c.3-.921 1.603-.921 1.902 0l1.519 4.674a1 1 0 00.95.69h4.915c.969 0 1.371 1.24.588 1.81l-3.976 2.888a1 1 0 00-.363 1.118l1.518 4.674c.3.922-.755 1.688-1.538 1.118l-3.976-2.888a1 1 0 00-1.176 0l-3.976 2.888c-.783.57-1.838-.197-1.538-1.118l1.518-4.674a1 1 0 00-.363-1.118l-3.976-2.888c-.784-.57-.38-1.81.588-1.81h4.914a1 1 0 00.951-.69l1.519-4.674z"></path>
                        </svg>
                        🏆 Produk Terlaris
                    </h2>
                </div>
                <div class="p-6">
                    @if($topProducts->count() > 0)
                        <div class="relative">
                            <canvas id="topProductsChart" width="400" height="250"></canvas>
                        </div>
                    @else
                        <div class="text-center py-16">
                            <div class="p-4 bg-slate-100 rounded-full inline-block mb-4">
                                <svg class="w-12 h-12 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                                </svg>
                            </div>
                            <p class="text-slate-500 font-medium">Belum ada data penjualan</p>
                            <p class="text-slate-400 text-sm">Data akan muncul setelah ada transaksi</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Recent Activity -->
        <div class="bg-white rounded-xl border border-slate-200 shadow-sm">
            <div class="p-6 border-b border-slate-200">
                <div class="flex items-center justify-between">
                    <h2 class="text-xl font-bold text-slate-800 flex items-center">
                        <svg class="w-6 h-6 mr-3 text-violet-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        🕐 Aktivitas Terbaru
                    </h2>
                    <a href="{{route('admin.transactions.index')}} " class="text-blue-600 hover:text-blue-700 text-sm font-semibold transition-colors duration-200">
                        Lihat semua
                    </a>
                </div>
            </div>
            
            <div class="overflow-hidden">
                @if($recentTransactions->count() > 0)
                    <div class="max-h-80 overflow-y-auto custom-scrollbar">
                        @foreach($recentTransactions as $transaction)
                        <div class="p-4 border-b border-slate-200 hover:bg-slate-50 transition-colors duration-200">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center">
                                    <div class="w-10 h-10 bg-gradient-to-r from-emerald-500 to-emerald-600 rounded-xl flex items-center justify-center mr-4 shadow-lg shadow-emerald-500/25">
                                        <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                                        </svg>
                                    </div>
                                    <div>
                                        <p class="text-slate-800 font-semibold">Transaksi #{{ $transaction->id }}</p>
                                        <p class="text-sm text-slate-600">oleh {{ $transaction->user->name }}</p>
                                        <p class="text-xs text-slate-500">{{ $transaction->created_at->diffForHumans() }}</p>
                                    </div>
                                </div>
                                <div class="text-right">
                                    <p class="text-lg font-bold text-emerald-600">Rp {{ number_format($transaction->total_amount, 0, ',', '.') }}</p>
                                    <p class="text-xs text-slate-500 font-medium">{{ $transaction->created_at->format('H:i') }}</p>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                @else
                    <div class="p-12 text-center">
                        <div class="p-4 bg-slate-100 rounded-full inline-block mb-4">
                            <svg class="w-12 h-12 text-slate-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                        </div>
                        <h3 class="text-lg font-semibold text-slate-700 mb-2">📝 Belum ada transaksi</h3>
                        <p class="text-slate-500 text-sm mb-6">Transaksi akan muncul di sini ketika kasir mulai melakukan penjualan</p>
                        <a href="{{ route('kasir.dashboard') }}" class="inline-flex items-center px-6 py-3 bg-gradient-to-r from-blue-600 to-blue-700 text-white rounded-xl font-semibold hover:from-blue-700 hover:to-blue-800 transition-all duration-300 shadow-lg hover:shadow-blue-500/25 transform hover:scale-105">
                            <svg class="w-5 h-5 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4m0 0L7 13m0 0l-1.5 6M7 13l-1.5-6M20 13v6a2 2 0 01-2 2H6a2 2 0 01-2-2v-6"></path>
                            </svg>
                            Mulai Transaksi
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Chart.js CDN -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.9.1/chart.min.js"></script>

<script>
// Revenue Chart
const ctx = document.getElementById('revenueChart').getContext('2d');
const monthlyData = @json($monthlyRevenue ?? []);
const months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];

// Prepare data for chart
const chartData = [];
const chartLabels = [];
for (let i = 1; i <= 12; i++) {
    chartLabels.push(months[i - 1]);
    chartData.push(monthlyData[i] || 0);
}

new Chart(ctx, {
    type: 'line',
    data: {
        labels: chartLabels,
        datasets: [{
            label: 'Revenue',
            data: chartData,
            borderColor: 'rgb(37, 99, 235)',
            backgroundColor: 'rgba(37, 99, 235, 0.1)',
            borderWidth: 3,
            fill: true,
            tension: 0.4,
            pointBackgroundColor: 'rgb(37, 99, 235)',
            pointBorderColor: 'rgba(255, 255, 255, 0.8)',
            pointBorderWidth: 2,
            pointRadius: 6,
            pointHoverRadius: 8
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: {
                display: false
            }
        },
        scales: {
            y: {
                beginAtZero: true,
                grid: {
                    color: 'rgba(148, 163, 184, 0.2)'
                },
                ticks: {
                    color: 'rgba(71, 85, 105, 0.8)',
                    callback: function(value) {
                        return 'Rp ' + value.toLocaleString('id-ID');
                    }
                }
            },
            x: {
                grid: {
                    color: 'rgba(148, 163, 184, 0.2)'
                },
                ticks: {
                    color: 'rgba(71, 85, 105, 0.8)'
                }
            }
        },
        elements: {
            point: {
                hoverBackgroundColor: 'rgb(37, 99, 235)'
            }
        }
    }
});

// Top Products Pie Chart
const topProductsData = @json($topProducts);
if (topProductsData.length > 0) {
    const pieCtx = document.getElementById('topProductsChart').getContext('2d');
    
    // Prepare data for pie chart
    const productNames = topProductsData.map(product => product.name.length > 15 ? product.name.substring(0, 15) + '...' : product.name);
    const productSales = topProductsData.map(product => product.transaction_items_count);
    
    // Generate vibrant colors that match the theme
    const colors = [
        'rgba(37, 99, 235, 0.8)',     // Blue
        'rgba(16, 185, 129, 0.8)',    // Emerald
        'rgba(139, 92, 246, 0.8)',    // Violet
        'rgba(249, 115, 22, 0.8)',    // Orange
        'rgba(239, 68, 68, 0.8)',     // Red
    ];
    
    const borderColors = [
        'rgba(37, 99, 235, 1)',
        'rgba(16, 185, 129, 1)',
        'rgba(139, 92, 246, 1)',
        'rgba(249, 115, 22, 1)',
        'rgba(239, 68, 68, 1)',
    ];

    new Chart(pieCtx, {
        type: 'doughnut',
        data: {
            labels: productNames,
            datasets: [{
                data: productSales,
                backgroundColor: colors.slice(0, productNames.length),
                borderColor: borderColors.slice(0, productNames.length),
                borderWidth: 2,
                hoverOffset: 8
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom',
                    labels: {
                        color: 'rgba(71, 85, 105, 0.8)',
                        padding: 20,
                        font: {
                            size: 12
                        },
                        generateLabels: function(chart) {
                            const data = chart.data;
                            if (data.labels.length && data.datasets.length) {
                                return data.labels.map((label, i) => {
                                    const sales = data.datasets[0].data[i];
                                    return {
                                        text: `${label} (${sales})`,
                                        fillStyle: data.datasets[0].backgroundColor[i],
                                        strokeStyle: data.datasets[0].borderColor[i],
                                        lineWidth: data.datasets[0].borderWidth,
                                        index: i
                                    };
                                });
                            }
                            return [];
                        }
                    }
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            const fullName = topProductsData[context.dataIndex].name;
                            const sales = context.parsed;
                            const total = context.dataset.data.reduce((a, b) => a + b, 0);
                            const percentage = ((sales / total) * 100).toFixed(1);
                            return `${fullName}: ${sales} terjual (${percentage}%)`;
                        }
                    }
                }
            },
            cutout: '50%'
        }
    });
}

// Export Report Function
function exportReport() {
    // Simulate export process
    const button = event.target.closest('a');
    const originalContent = button.innerHTML;
    
    button.innerHTML = `
        <svg class="w-6 h-6 mr-3 animate-spin" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
        </svg>
        <div>
            <span class="font-semibold text-sm">Mengexport...</span>
            <p class="text-xs text-violet-200">Sedang memproses data</p>
        </div>
    `;
    
    setTimeout(() => {
        button.innerHTML = originalContent;
        // Show success message
        const successMsg = document.createElement('div');
        successMsg.className = 'fixed top-4 right-4 bg-emerald-50 border border-emerald-200 text-emerald-800 px-6 py-4 rounded-xl shadow-lg z-50';
        successMsg.innerHTML = `
            <div class="flex items-center">
                <svg class="w-5 h-5 mr-3 text-emerald-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                </svg>
                <span class="font-semibold">Laporan berhasil diexport!</span>
            </div>
        `;
        document.body.appendChild(successMsg);
        
        setTimeout(() => {
            successMsg.remove();
        }, 3000);
    }, 2000);
}

// Auto update time
function updateTime() {
    const now = new Date();
    const timeElement = document.querySelector('.text-lg.font-bold.text-blue-600');
    if (timeElement) {
        timeElement.textContent = now.toLocaleTimeString('id-ID', { 
            hour: '2-digit', 
            minute: '2-digit' 
        }) + ' WIB';
    }
}

setInterval(updateTime, 1000);
</script>

<style>
/* Custom scrollbar for activity list */
.custom-scrollbar::-webkit-scrollbar {
    width: 6px;
}

.custom-scrollbar::-webkit-scrollbar-track {
    background: #f1f5f9;
    border-radius: 10px;
}

.custom-scrollbar::-webkit-scrollbar-thumb {
    background: #cbd5e1;
    border-radius: 10px;
}

.custom-scrollbar::-webkit-scrollbar-thumb:hover {
    background: #94a3b8;
}

/* Chart container */
#revenueChart, #topProductsChart {
    height: 300px !important;
}

/* Animation for loading state */
@keyframes spin {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
}

.animate-spin {
    animation: spin 1s linear infinite;
}

/* Hover effects */
.transform:hover {
    transform: scale(1.02);
}

/* Drop shadow for titles */
.drop-shadow-sm {
    filter: drop-shadow(0 1px 2px rgba(0, 0, 0, 0.05));
}
</style>
@endsection